<?php

class PxlTextMarquee_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_text_marquee';
    protected $title = 'BR Text Marquee';
    protected $icon = 'eicon-code-highlight';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"section_content","label":"Content","tab":"content","controls":[{"name":"stroke","label":"Stroke","type":"switcher","label_on":"On","label_off":"Off","default":""},{"name":"gradient","label":"Linear Gradient","type":"switcher","label_on":"On","label_off":"Off","default":""},{"name":"style","label":"Style","type":"select","options":{"":"Default","text-on-bg":"Text On Background","round-box-border":"Round Box Border"},"default":""},{"name":"l_style","label":"Style","type":"select","options":{"":"Default","text-custom":"Custom","text-dark":"Text Color","text-stroke":"Text Stroke","text-gradient":"Text Gradient","text-gradient1":"Text Gradient Dark","text-stroke-gradient":"Text Stroke Gradient"},"default":"text-custom"},{"name":"saperator","label":"Saperator","type":"select","options":{"":"Space","dot":"Dot"},"default":""},{"name":"items","label":"Content","type":"repeater","controls":[{"name":"text","label":"Text","type":"text","label_block":true},{"name":"link","label":"Link","type":"url","label_block":true},{"name":"pxl_icon","label":"Icon","type":"icons","fa4compatibility":"icon"}],"title_field":"{{{ text }}}"}]},{"name":"section_settings","label":"Style","tab":"settings","controls":[{"name":"opt_transition","label":"Transection","type":"select","options":{"linear":"Linear"},"default":"linear"},{"name":"opt_delay_before_start","label":"Delay Before Start","type":"number","description":"Time unit is ms."},{"name":"opt_direction","label":"Direction","type":"select","options":{"top":"Top","right":"Right","bottom":"Bottom","left":"Left"},"default":"left"},{"name":"opt_duplicated","label":"Duplicated","type":"switcher","default":"no","return_value":"yes","description":"Should the marquee be duplicated to show an effect of continuous flow."},{"name":"opt_gap","label":"Gap","type":"number","condition":{"opt_duplicated":"yes"}},{"name":"opt_duration","label":"Duration","type":"number","description":"Time unit is ms."},{"name":"opt_pause_on_hover","label":"Pause On Hover","type":"switcher","default":"no","return_value":"yes","description":"Pause the marquee on hover."},{"name":"opt_start_visible","label":"Start Visible","type":"switcher","return_value":"yes","default":"no","description":"The marquee will be visible from the start."}]},{"name":"section_style_layout","label":"Style","tab":"style","controls":[{"name":"normal","label":"NORMAL","type":"heading"},{"name":"height","label":"Height","type":"slider","size_units":["px","%"],"range":{"px":{"min":1,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-text-marquee,{{WRAPPER}} .pxl-text-marquee .pxl-item":"height: {{SIZE}}{{UNIT}};"}},{"name":"bg_color","label":"Backgroun Color","type":"color","selectors":{"{{WRAPPER}} .pxl-text-marquee":"background-color: {{VALUE}};"}},{"name":"btn_border","label":"Border","type":"border","control_type":"group","selector":"{{WRAPPER}} .pxl-text-marquee .pxl-marquee-inner .pxl-item"},{"name":"divider","type":"divider"},{"name":"spacing_option","label":"SPACING","type":"heading"},{"name":"padding_l","label":"Padding","type":"dimensions","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-text-marquee .pxl-marquee-inner":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"control_type":"responsive"},{"name":"margin_l","label":"Margin","type":"dimensions","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-text-marquee .pxl-marquee-inner":"margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"control_type":"responsive"}]},{"name":"section_style_text","label":"Text","tab":"style","controls":[{"name":"text_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-text-marquee .pxl-item--text, {{WRAPPER}} .pxl-text-marquee .pxl-item--saperator":"color: {{VALUE}};"}},{"name":"text_stroke_color","label":"Stroke Color","type":"color","selectors":{"{{WRAPPER}} .pxl-text-marquee .pxl-item--text":"-webkit-text-stroke-color: {{VALUE}};"}},{"name":"text_stroke_width","label":"Stroke Width","type":"slider","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-text-marquee .pxl-item--text":"stroke-width: {{SIZE}}{{UNIT}}; -webkit-text-stroke-width: {{SIZE}}{{UNIT}}"}},{"name":"text_typography","label":"Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-text-marquee .pxl-item--text, {{WRAPPER}} .pxl-text-marquee .pxl-item--saperator"},{"name":"is_text_color_gradient","label":"Is Text Gradient Color","type":"switcher","default":"false"},{"name":"bg_color_gradient_from","label":"Gradient - Color From","type":"color","default":"","selectors":{"{{WRAPPER}} .pxl-text-marquee .pxl-item--text, \r\n                                {{WRAPPER}} .pxl-text-marquee.text-custom .pxl-item--text":"--gradient-color-from: {{VALUE}};"},"condition":{"is_text_color_gradient!":"false"}},{"name":"bg_color_gradient_to","label":"Gradient - Color To","type":"color","default":"","selectors":{"{{WRAPPER}} .pxl-text-marquee .pxl-item--text, \r\n                                {{WRAPPER}} .pxl-text-marquee.text-custom .pxl-item--text":"--gradient-color-to: {{VALUE}};"},"condition":{"is_text_color_gradient!":"false"}}]},{"name":"section_style_icon","label":"Icon","tab":"style","controls":[{"name":"icon_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-text-marquee .pxl-item--icon i,\r\n                                {{WRAPPER}} .pxl-text-marquee .pxl-item--icon svg":"color: {{VALUE}}; fill: {{VALUE}}"}},{"name":"icon_stroke_width","label":"Stroke Width","type":"slider","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-text-marquee .pxl-item--icon svg path":"stroke-width: {{SIZE}}{{UNIT}};"}},{"name":"icon_stroke_color","label":"Stroke Color","type":"color","selectors":{"{{WRAPPER}} .pxl-text-marquee .pxl-item--icon svg path":"stroke: {{VALUE}};"}},{"name":"icon_size","label":"Box Size","type":"slider","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-text-marquee .pxl-item--icon svg":"width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};"}}]},{"name":"section_animation","label":"Animation","tab":"style","condition":[],"controls":[{"name":"pxl_animate","label":"Bravis Animate","type":"select","options":{"":"None","wow bounce":"bounce","wow flash":"flash","wow pulse":"pulse","wow rubberBand":"rubberBand","wow shake":"shake","wow swing":"swing","wow tada":"tada","wow wobble":"wobble","bounce-top wow":"bounceTop","wow bounceIn":"bounceIn","wow bounceInDown":"bounceInDown","wow bounceInLeft":"bounceInLeft","wow bounceInRight":"bounceInRight","wow bounceInUp":"bounceInUp","wow bounceOut":"bounceOut","wow bounceOutDown":"bounceOutDown","wow bounceOutLeft":"bounceOutLeft","wow bounceOutRight":"bounceOutRight","wow bounceOutUp":"bounceOutUp","wow fadeIn":"fadeIn","wow fadeInDown":"fadeInDown","wow fadeInDownBig":"fadeInDownBig","wow fadeInLeft":"fadeInLeft","wow fadeInLeftBig":"fadeInLeftBig","wow fadeInRight":"fadeInRight","wow fadeInRightBig":"fadeInRightBig","wow fadeInUp":"fadeInUp","wow fadeInUpBig":"fadeInUpBig","wow fadeOut":"fadeOut","wow fadeOutDown":"fadeOutDown","wow fadeOutDownBig":"fadeOutDownBig","wow fadeOutLeft":"fadeOutLeft","wow fadeOutLeftBig":"fadeOutLeftBig","wow fadeOutRight":"fadeOutRight","wow fadeOutRightBig":"fadeOutRightBig","wow fadeOutUp":"fadeOutUp","wow fadeOutUpBig":"fadeOutUpBig","wow flip":"flip","wow flipCase":"flipCase","wow flipInX":"flipInX","wow flipInY":"flipInY","wow flipOutX":"flipOutX","wow flipOutY":"flipOutY","wow lightSpeedIn":"lightSpeedIn","wow lightSpeedOut":"lightSpeedOut","wow rotateIn":"rotateIn","wow rotateInDownLeft":"rotateInDownLeft","wow rotateInDownRight":"rotateInDownRight","wow rotateInUpLeft":"rotateInUpLeft","wow rotateInUpRight":"rotateInUpRight","wow rotateOut":"rotateOut","wow rotateOutDownLeft":"rotateOutDownLeft","wow rotateOutDownRight":"rotateOutDownRight","wow rotateOutUpLeft":"rotateOutUpLeft","wow rotateOutUpRight":"rotateOutUpRight","wow hinge":"hinge","wow rollIn":"rollIn","wow rollOut":"rollOut","wow zoomInSmall":"zoomInSmall","wow zoomIn":"zoomInBig","wow zoomOut":"zoomOut","wow skewIn":"skewInLeft","wow skewInRight":"skewInRight","wow skewInBottom":"skewInBottom","wow skewInTop":"skewInTop","wow RotatingY":"RotatingY","wow PXLfadeInUp":"PXLfadeInUp","fadeInPopup":"fadeInPopup","wow pxl-expanding-line-effect":"Expanding Line Effect"},"default":""},{"name":"pxl_animate_delay","label":"Animate Delay","type":"text","default":"0","description":"Enter number. Default 0ms"}]}]}';
    protected $styles = array(  );
    protected $scripts = array( 'marquee','pxl-marquee' );
}