<?php

class PxlPricing_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_pricing';
    protected $title = 'BR Pricing';
    protected $icon = 'eicon-progress-tracker';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"section_content","label":"Content","tab":"content","controls":[{"name":"popular","label":"Popular","type":"text","label_block":true},{"name":"price","label":"Price","type":"number"},{"name":"currency","label":"Currency","type":"text"},{"name":"package","label":"Package","type":"text","label_block":true}]},{"name":"section_content_feature","label":"Feature","tab":"content","controls":[{"name":"pxl_icon","label":"Icon","type":"icons","fa4compatibility":"icon"},{"name":"items","label":"Items","type":"repeater","controls":[{"name":"show_in","label":"Show in Card","type":"text","placeholder":"Ex: 1-3..","description":"Leave blank to apply to all. Separated by &quot;-&quot;"},{"name":"text","label":"Text","type":"text","label_block":true}],"title_field":"{{{ text }}}"}]},{"name":"section_content_button","label":"Button","tab":"content","controls":[{"name":"btn_text","label":"Text","type":"text","default":"Purchase Now","label_block":true},{"name":"btn_link","label":"Link","type":"url","url":"#","label_block":true},{"name":"btn_icon","label":"Icon","type":"icons","fa4compatibility":"icon"}]},{"name":"section_style_popular","label":"Popular","tab":"style","controls":[{"name":"popular_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-pricing .pxl-item--popular":"color: {{VALUE}};"}},{"name":"popular_typography","label":"Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-pricing .pxl-item--popular"},{"name":"popular_box_color","label":"Box Color","type":"color","selectors":{"{{WRAPPER}} .pxl-pricing .pxl-item--popular span":"background-color: {{VALUE}};"}},{"name":"popular_box_padding","label":"Box Padding","type":"dimensions","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-pricing .pxl-item--popular span":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"section_style_price","label":"Price","tab":"style","controls":[{"name":"price_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-pricing .pxl-item--price":"color: {{VALUE}};"}},{"name":"price_typography","label":"Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-pricing .pxl-item--price"},{"name":"currency_size","label":"Currency Size","type":"slider","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-pricing .pxl-item--price .pxl-item--currency":"font-size: {{SIZE}}{{UNIT}};"}}]},{"name":"section_style_package","label":"Package","tab":"style","controls":[{"name":"package_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-pricing .pxl-item--package":"color: {{VALUE}};"}},{"name":"package_typography","label":"Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-pricing .pxl-item--package"}]},{"name":"section_style_text","label":"Feature","tab":"style","controls":[{"name":"text_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-pricing .pxl-items .pxl-item":"color: {{VALUE}};"}},{"name":"text_typography","label":"Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-pricing .pxl-items .pxl-item"},{"name":"icon_size","label":"Icon Size","type":"slider","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-pricing .pxl-items .pxl-item i":"font-size: {{SIZE}}{{UNIT}};"}},{"name":"icon_color","label":"Icon Color","type":"color","selectors":{"{{WRAPPER}} .pxl-pricing .pxl-items .pxl-item i":"color: {{VALUE}};","{{WRAPPER}} .pxl-pricing .pxl-items .pxl-item svg path":"fill: {{VALUE}};"}}]},{"name":"section_style_button","label":"Button","tab":"style","controls":[{"name":"button_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-pricing .pxl-btn-wrap .pxl-item--btn":"color: {{VALUE}};"}},{"name":"button_typography","label":"Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-pricing .pxl-btn-wrap .pxl-item--btn"},{"name":"icon_button_size","label":"Icon Size","type":"slider","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-pricing .pxl-btn-wrap .pxl-item--btn i":"font-size: {{SIZE}}{{UNIT}};"}}]}]}';
    protected $styles = array(  );
    protected $scripts = array(  );
}