<?php
/**
 * Template part for displaying a message that posts cannot be found
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package sway
 * by KeyDesign
 */

?>

<section id="posts-content" class="container">
	<div class="row">
		<h2 class="section-title"><?php esc_html_e( 'Nothing Found', 'sway' ); ?></h2>
		<?php
		if ( is_home() && current_user_can( 'publish_posts' ) ) : ?>
			<p><?php printf( wp_kses( __( 'Ready to publish your first post? <a href="%1$s">Get started here</a>.', 'sway' ), array( 'a' => array( 'href' => array() ) ) ), esc_url( admin_url( 'post-new.php' ) ) ); ?></p>
		<?php elseif ( is_search() ) : ?>
			<p class="section-subheading"><?php esc_html_e( 'Sorry, but nothing matched your search terms. Please try again using different keywords.', 'sway' ); ?></p>
			<?php get_search_form();
		else : ?>
			<p><?php esc_html_e( 'It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'sway' ); ?></p>
			<?php get_search_form();
		endif; ?>
	</div>
</section><!-- .no-results -->
