<?php
	$master_study_lite_first_color = get_theme_mod('master_study_lite_first_color');
	$master_study_lite_second_color = get_theme_mod('master_study_lite_second_color');
	$master_study_lite_custom_css ='';

	/*------------------ Global First Color -----------*/

	if ($master_study_lite_first_color) {
		$master_study_lite_custom_css .= ':root {';
		$master_study_lite_custom_css .= '--first-theme-color: ' . esc_attr($master_study_lite_first_color) . ' !important;';
		$master_study_lite_custom_css .= '} ';
	}

	/*------------------ Global Second Color -----------*/

	if ($master_study_lite_second_color) {
		$master_study_lite_custom_css .= ':root {';
		$master_study_lite_custom_css .= '--second-theme-color: ' . esc_attr($master_study_lite_second_color) . ' !important;';
		$master_study_lite_custom_css .= '} ';
	}

	/*---------------------------Width Layout -------------------*/
	$master_study_lite_theme_lay = get_theme_mod( 'master_study_lite_width_layout_options','Default');
    if($master_study_lite_theme_lay == 'Default'){
		$master_study_lite_custom_css .='body{';
			$master_study_lite_custom_css .='max-width: 100%;';
		$master_study_lite_custom_css .='}';
	}else if($master_study_lite_theme_lay == 'Container Layout'){
		$master_study_lite_custom_css .='body{';
			$master_study_lite_custom_css .='width: 100%;padding-right: 15px;padding-left: 15px;margin-right: auto;margin-left: auto;';
		$master_study_lite_custom_css .='}';
		$master_study_lite_custom_css .='.page-template-home-page #header{';
			$master_study_lite_custom_css .='position: static; background-color: #000;';
		$master_study_lite_custom_css .='}';
	}else if($master_study_lite_theme_lay == 'Box Layout'){
		$master_study_lite_custom_css .='body{';
			$master_study_lite_custom_css .='max-width: 1140px; width: 100%; padding-right: 15px; padding-left: 15px; margin-right: auto; margin-left: auto;';
		$master_study_lite_custom_css .='}';
		$master_study_lite_custom_css .='.page-template-home-page #header{';
			$master_study_lite_custom_css .='position: static; background-color: #000;';
		$master_study_lite_custom_css .='}';
	}

	/*-------------- Footer Text -------------------*/
	$master_study_lite_footer_text_align = get_theme_mod('master_study_lite_footer_text_align');
	$master_study_lite_custom_css .='.copyright-wrapper{';
		$master_study_lite_custom_css .='text-align: '.esc_attr($master_study_lite_footer_text_align).';';
	$master_study_lite_custom_css .='}';
	$master_study_lite_custom_css .='
	@media screen and (max-width:575px) {
		.copyright-wrapper{';
			$master_study_lite_custom_css .='text-align: center;'.esc_attr($master_study_lite_footer_text_align).'';
	$master_study_lite_custom_css .='} }';

	$master_study_lite_footer_text_padding = get_theme_mod('master_study_lite_footer_text_padding');
	$master_study_lite_custom_css .='.copyright-wrapper{';
		$master_study_lite_custom_css .='padding-top: '.esc_attr($master_study_lite_footer_text_padding).'px !important; padding-bottom: '.esc_attr($master_study_lite_footer_text_padding).'px !important;';
	$master_study_lite_custom_css .='}';

	$master_study_lite_footer_bg_color = get_theme_mod('master_study_lite_footer_bg_color');
	$master_study_lite_custom_css .='.footer-wp{';
		$master_study_lite_custom_css .='background-color: '.esc_attr($master_study_lite_footer_bg_color).';';
	$master_study_lite_custom_css .='}';

	$master_study_lite_footer_bg_image = get_theme_mod('master_study_lite_footer_bg_image');
	if($master_study_lite_footer_bg_image != false){
		$master_study_lite_custom_css .='.footer-wp{';
			$master_study_lite_custom_css .='background: url('.esc_attr($master_study_lite_footer_bg_image).'); background-size: cover;';
		$master_study_lite_custom_css .='}';
	}

	//footer heading letter spacing
	$master_study_lite_footer_heading_letter_spacing = get_theme_mod('master_study_lite_footer_heading_letter_spacing',1);
	$master_study_lite_custom_css .='.footer-wp h3 {';
		$master_study_lite_custom_css .='letter-spacing: '.esc_attr($master_study_lite_footer_heading_letter_spacing).'px;';
	$master_study_lite_custom_css .='}';
	
    // footer image position
	$master_study_lite_footer_img_position = get_theme_mod('master_study_lite_footer_img_position','center center');
	if($master_study_lite_footer_img_position != false){
		$master_study_lite_custom_css .='.footer-wp{';
			$master_study_lite_custom_css .='background-position: '.esc_attr($master_study_lite_footer_img_position).'!important;';
		$master_study_lite_custom_css .='}';
	}		

	// footer heading font weight
	$master_study_lite_footer_heading_font_weight = get_theme_mod( 'master_study_lite_footer_heading_font_weight','500');
	if($master_study_lite_footer_heading_font_weight != ''){
		$master_study_lite_custom_css .='.footer-wp h3{';
			$master_study_lite_custom_css .='font-weight: '.esc_attr($master_study_lite_footer_heading_font_weight).';';
		$master_study_lite_custom_css .='}';
	}

	// Footer Attatchment
	$master_study_lite_theme_lay = get_theme_mod( 'master_study_lite_footer_attatchment','scroll');
	if($master_study_lite_theme_lay == 'fixed'){
		$master_study_lite_custom_css .='.footer-wp{';
			$master_study_lite_custom_css .='background-attachment: fixed;';
		$master_study_lite_custom_css .='}';
	}elseif ($master_study_lite_theme_lay == 'scroll'){
		$master_study_lite_custom_css .='.footer-wp{';
			$master_study_lite_custom_css .='background-attachment: scroll;';
		$master_study_lite_custom_css .='}';
	}

	$master_study_lite_copyright_text_font_size = get_theme_mod('master_study_lite_copyright_text_font_size', 15);
	$master_study_lite_custom_css .='.copyright-wrapper p, .copyright-wrapper a{';
		$master_study_lite_custom_css .='font-size: '.esc_attr($master_study_lite_copyright_text_font_size).'px;';
	$master_study_lite_custom_css .='}';

	$master_study_lite_footer_heading_font_size = get_theme_mod('master_study_lite_footer_heading_font_size');
	$master_study_lite_custom_css .='.footer-wp h3{';
		$master_study_lite_custom_css .='font-size: '.esc_attr($master_study_lite_footer_heading_font_size).'px;';
	$master_study_lite_custom_css .='}';

	// footer padding
	$master_study_lite_footer_padding = get_theme_mod('master_study_lite_footer_padding');
	$master_study_lite_custom_css .='.footer-wp{';
		$master_study_lite_custom_css .='padding: '.esc_attr($master_study_lite_footer_padding).'px;';
	$master_study_lite_custom_css .='}';

	$master_study_lite_footer_heading = get_theme_mod( 'master_study_lite_footer_heading','Left');
    if($master_study_lite_footer_heading == 'Left'){
		$master_study_lite_custom_css .='.footer-wp h3, .footer-wp .wp-block-search .wp-block-search__label{';
		$master_study_lite_custom_css .='text-align: left;';
		$master_study_lite_custom_css .='}';
	}else if($master_study_lite_footer_heading == 'Center'){
		$master_study_lite_custom_css .='.footer-wp h3, .footer-wp .wp-block-search .wp-block-search__label{';
			$master_study_lite_custom_css .='text-align: center;';
		$master_study_lite_custom_css .='}';
		$master_study_lite_custom_css .='.footer-wp h3:after, .footer-wp .wp-block-heading:after{';
			$master_study_lite_custom_css .='margin: 7px auto;';
		$master_study_lite_custom_css .='}';
		$master_study_lite_custom_css .='
		@media screen and (max-width:767px) {
			.footer-wp h3, .footer-wp .wp-block-search .wp-block-search__label{';
				$master_study_lite_custom_css .='text-align: left;';
				$master_study_lite_custom_css .='}
			.footer-wp h3:after, .footer-wp .wp-block-heading:after{';
				$master_study_lite_custom_css .='margin: 7px 0 0;';
				$master_study_lite_custom_css .='}
		}';
	}else if($master_study_lite_footer_heading == 'Right'){
		$master_study_lite_custom_css .='.footer-wp h3, .footer-wp .wp-block-search .wp-block-search__label{';
			$master_study_lite_custom_css .='text-align: right; padding-bottom: 25px;';
		$master_study_lite_custom_css .='}';
		$master_study_lite_custom_css .='.footer-wp .widget, .footer-wp aside{';
			$master_study_lite_custom_css .='position: relative;';
		$master_study_lite_custom_css .='}';
		$master_study_lite_custom_css .='.footer-wp h3:after, .footer-wp .wp-block-heading:after{';
			$master_study_lite_custom_css .='position: absolute; right: 0;';
		$master_study_lite_custom_css .='}';
		$master_study_lite_custom_css .='
		@media screen and (max-width:767px) {
			.footer-wp h3, .footer-wp .wp-block-search .wp-block-search__label{';
				$master_study_lite_custom_css .='text-align: left;';
				$master_study_lite_custom_css .='}
			.footer-wp h3:after, .footer-wp .wp-block-heading:after{';
				$master_study_lite_custom_css .='left: 0;';
				$master_study_lite_custom_css .='}
		}';
	}

	$master_study_lite_footer_content = get_theme_mod( 'master_study_lite_footer_content','Left');
    if($master_study_lite_footer_content == 'Left'){
		$master_study_lite_custom_css .='.footer-wp .widget{';
		$master_study_lite_custom_css .='text-align: left;';
		$master_study_lite_custom_css .='}';
	}else if($master_study_lite_footer_content == 'Center'){
		$master_study_lite_custom_css .='.footer-wp .widget{';
			$master_study_lite_custom_css .='text-align: center;';
		$master_study_lite_custom_css .='}';
		$master_study_lite_custom_css .='
		@media screen and (max-width:767px) {
			.footer-wp .widget{';
				$master_study_lite_custom_css .='text-align: left;';
				$master_study_lite_custom_css .='} }';
	}else if($master_study_lite_footer_content == 'Right'){
		$master_study_lite_custom_css .='.footer-wp .widget{';
			$master_study_lite_custom_css .='text-align: right;';
		$master_study_lite_custom_css .='}';
		$master_study_lite_custom_css .='
		@media screen and (max-width:767px) {
			.footer-wp .widget{';
				$master_study_lite_custom_css .='text-align: left;';
				$master_study_lite_custom_css .='} }';
	}

	//Footer social icons font size
	$master_study_lite_footer_social_icons_size = get_theme_mod('master_study_lite_footer_social_icons_size', 15);
	$master_study_lite_custom_css .='.copyright-wrapper a i{';
		$master_study_lite_custom_css .='font-size: '.esc_attr($master_study_lite_footer_social_icons_size).'px;';
	$master_study_lite_custom_css .='}';		

	/*------------- Back to Top  -------------------*/
	$master_study_lite_back_to_top_border_radius = get_theme_mod('master_study_lite_back_to_top_border_radius');
	$master_study_lite_custom_css .='#scrollbutton {';
		$master_study_lite_custom_css .='border-radius: '.esc_attr($master_study_lite_back_to_top_border_radius).'px;';
	$master_study_lite_custom_css .='}';

	$master_study_lite_scroll_icon_font_size = get_theme_mod('master_study_lite_scroll_icon_font_size', 22);
	$master_study_lite_custom_css .='#scrollbutton {';
		$master_study_lite_custom_css .='font-size: '.esc_attr($master_study_lite_scroll_icon_font_size).'px;';
	$master_study_lite_custom_css .='}';

	// back to top icon color
	$master_study_lite_scroll_icon_color = get_theme_mod('master_study_lite_scroll_icon_color');
	$master_study_lite_custom_css .='#scrollbutton i{';
		$master_study_lite_custom_css .='color: '.esc_attr($master_study_lite_scroll_icon_color).';';
	$master_study_lite_custom_css .='}';

	// back to top icon hover color
	$master_study_lite_scroll_icon_hover_color = get_theme_mod('master_study_lite_scroll_icon_hover_color');
	$master_study_lite_custom_css .='#scrollbutton i:hover{';
		$master_study_lite_custom_css .='color: '.esc_attr($master_study_lite_scroll_icon_hover_color).';';
	$master_study_lite_custom_css .='}';

	// back to top bg color
	$master_study_lite_scroll_icon_background = get_theme_mod('master_study_lite_scroll_icon_background');
	$master_study_lite_custom_css .='#scrollbutton{';
		$master_study_lite_custom_css .='background-color: '.esc_attr($master_study_lite_scroll_icon_background).';';
		$master_study_lite_custom_css .='border-color: '.esc_attr($master_study_lite_scroll_icon_background).';';
	$master_study_lite_custom_css .='}';

	// back to top bg hover color
	$master_study_lite_scroll_icon_background_hover = get_theme_mod('master_study_lite_scroll_icon_background_hover');
	$master_study_lite_custom_css .='#scrollbutton:hover{';
		$master_study_lite_custom_css .='background-color: '.esc_attr($master_study_lite_scroll_icon_background_hover).';';
		$master_study_lite_custom_css .='border-color: '.esc_attr($master_study_lite_scroll_icon_background_hover).';';
	$master_study_lite_custom_css .='}';

	$master_study_lite_top_bottom_scroll_padding = get_theme_mod('master_study_lite_top_bottom_scroll_padding', 7);
	$master_study_lite_custom_css .='#scrollbutton {';
		$master_study_lite_custom_css .='padding-top: '.esc_attr($master_study_lite_top_bottom_scroll_padding).'px; padding-bottom: '.esc_attr($master_study_lite_top_bottom_scroll_padding).'px;';
	$master_study_lite_custom_css .='}';

	$master_study_lite_left_right_scroll_padding = get_theme_mod('master_study_lite_left_right_scroll_padding', 17);
	$master_study_lite_custom_css .='#scrollbutton {';
		$master_study_lite_custom_css .='padding-left: '.esc_attr($master_study_lite_left_right_scroll_padding).'px; padding-right: '.esc_attr($master_study_lite_left_right_scroll_padding).'px;';
	$master_study_lite_custom_css .='}';

	//First Cap
	$master_study_lite_show_first_caps = get_theme_mod('master_study_lite_show_first_caps', 'false');
	if($master_study_lite_show_first_caps == 'true' ){
	$master_study_lite_custom_css .='.blog-section .mainbox .new-text p:nth-of-type(1)::first-letter{';
	$master_study_lite_custom_css .=' font-size: 55px; font-weight: 600;';
	$master_study_lite_custom_css .=' margin-right: 6px;';
	$master_study_lite_custom_css .=' line-height: 1;';
	$master_study_lite_custom_css .='}';
	}elseif($master_study_lite_show_first_caps == 'false' ){
	$master_study_lite_custom_css .='.blog-section .mainbox .new-text p:nth-of-type(1)::first-letter {';
	$master_study_lite_custom_css .='display: none;';
	$master_study_lite_custom_css .='}';
	}

	/*-------------- Post Button  -------------------*/

	$master_study_lite_btn_font_size_option = get_theme_mod('master_study_lite_btn_font_size_option');
	$master_study_lite_custom_css .='.postbtn a{';
		$master_study_lite_custom_css .='font-size: '.esc_attr($master_study_lite_btn_font_size_option).'px !important;';
	$master_study_lite_custom_css .='}';

	$master_study_lite_theme_lay = get_theme_mod( 'master_study_lite_button_text_tranform','Capitalize');
    if($master_study_lite_theme_lay == 'Uppercase'){
		$master_study_lite_custom_css .='.postbtn a{';
			$master_study_lite_custom_css .='text-transform: uppercase;';
		$master_study_lite_custom_css .='}';
	}else if($master_study_lite_theme_lay == 'Lowercase'){
		$master_study_lite_custom_css .='.postbtn a{';
			$master_study_lite_custom_css .='text-transform: lowercase;';
		$master_study_lite_custom_css .='}';
	}
	else if($master_study_lite_theme_lay == 'Capitalize'){
		$master_study_lite_custom_css .='.postbtn a{';
			$master_study_lite_custom_css .='text-transform: capitalize;';
		$master_study_lite_custom_css .='}';
	}

	// button font weight
	$master_study_lite_button_font_weight = get_theme_mod( 'master_study_lite_button_font_weight','700');
	if($master_study_lite_button_font_weight != ''){
		$master_study_lite_custom_css .='.postbtn a{';
			$master_study_lite_custom_css .='font-weight: '.esc_attr($master_study_lite_button_font_weight).';';
		$master_study_lite_custom_css .='}';
	}

	$master_study_lite_post_button_padding_top = get_theme_mod('master_study_lite_post_button_padding_top');
	$master_study_lite_custom_css .='.postbtn a, #comments input[type="submit"].submit{';
		$master_study_lite_custom_css .='padding-top: '.esc_attr($master_study_lite_post_button_padding_top).'px !important; padding-bottom: '.esc_attr($master_study_lite_post_button_padding_top).'px !important;';
	$master_study_lite_custom_css .='}';

	$master_study_lite_post_button_padding_right = get_theme_mod('master_study_lite_post_button_padding_right');
	$master_study_lite_custom_css .='.postbtn a, #comments input[type="submit"].submit{';
		$master_study_lite_custom_css .='padding-left: '.esc_attr($master_study_lite_post_button_padding_right).'px !important; padding-right: '.esc_attr($master_study_lite_post_button_padding_right).'px !important;';
	$master_study_lite_custom_css .='}';

	// button letter spacing
	$master_study_lite_button_letter_spacing = get_theme_mod('master_study_lite_button_letter_spacing', '0');
	$master_study_lite_custom_css .='.postbtn a {';
		$master_study_lite_custom_css .='letter-spacing: '.esc_attr($master_study_lite_button_letter_spacing).'px;';
	$master_study_lite_custom_css .='}';		
	
	//Button Shape
	$master_study_lite_btn_shape = get_theme_mod('master_study_lite_btn_shape', 'Square');
	if($master_study_lite_btn_shape == 'Square' ){
		$master_study_lite_custom_css .='.inner-service .mainbox .postbtn a{';
			$master_study_lite_custom_css .=' border-radius: 0';
		$master_study_lite_custom_css .='}';
	}elseif($master_study_lite_btn_shape == 'Round' ){
		$master_study_lite_custom_css .='.inner-service .mainbox .postbtn a{';
			$master_study_lite_custom_css .=' border-radius: .3em';
		$master_study_lite_custom_css .='}';
	}elseif($master_study_lite_btn_shape == 'Pill' ){
		$master_study_lite_custom_css .='.inner-service .mainbox .postbtn a{';
			$master_study_lite_custom_css .=' border-radius: 2em;';
		$master_study_lite_custom_css .='}';
	}

	$master_study_lite_post_comment_enable = get_theme_mod('master_study_lite_post_comment_enable',true);
	if($master_study_lite_post_comment_enable == false){
		$master_study_lite_custom_css .='#comments{';
			$master_study_lite_custom_css .='display: none;';
		$master_study_lite_custom_css .='}';
	}

	/*----------- Preloader Color Option  ----------------*/
	$master_study_lite_preloader_bg_color_option = get_theme_mod('master_study_lite_preloader_bg_color_option');
	$master_study_lite_preloader_icon_color_option = get_theme_mod('master_study_lite_preloader_icon_color_option');
	$master_study_lite_custom_css .='.frame{';
		$master_study_lite_custom_css .='background-color: '.esc_attr($master_study_lite_preloader_bg_color_option).';';
	$master_study_lite_custom_css .='}';
	$master_study_lite_custom_css .='.dot-1,.dot-2,.dot-3{';
		$master_study_lite_custom_css .='background-color: '.esc_attr($master_study_lite_preloader_icon_color_option).';';
	$master_study_lite_custom_css .='}';

	// preloader type
	$master_study_lite_theme_lay = get_theme_mod( 'master_study_lite_preloader_type','First Preloader Type');
    if($master_study_lite_theme_lay == 'First Preloader Type'){
		$master_study_lite_custom_css .='.dot-1, .dot-2, .dot-3{';
			$master_study_lite_custom_css .='';
		$master_study_lite_custom_css .='}';
	}else if($master_study_lite_theme_lay == 'Second Preloader Type'){
		$master_study_lite_custom_css .='.dot-1, .dot-2, .dot-3{';
			$master_study_lite_custom_css .='border-radius:0;';
		$master_study_lite_custom_css .='}';
	}

    // preloader background image
	$master_study_lite_preloader_bg_img = get_theme_mod('master_study_lite_preloader_bg_img');
	if($master_study_lite_preloader_bg_img != false){
		$master_study_lite_custom_css .='.frame {';
			$master_study_lite_custom_css .='background: url('.esc_attr($master_study_lite_preloader_bg_img).');-webkit-background-size: cover; -moz-background-size: cover; -o-background-size: cover; background-size: cover;';
		$master_study_lite_custom_css .='}';
	}		

	/*------------------ Skin Option  -------------------*/
	$master_study_lite_theme_lay = get_theme_mod( 'master_study_lite_background_skin','Without Background');
    if($master_study_lite_theme_lay == 'With Background'){
		$master_study_lite_custom_css .='.inner-service,#sidebar .widget,.woocommerce ul.products li.product, .woocommerce-page ul.products li.product,.front-page-content,.background-img-skin{';
			$master_study_lite_custom_css .='background-color: #F6F6F6; padding:20px;';
		$master_study_lite_custom_css .='}';
		$master_study_lite_custom_css .='.login-box a{';
			$master_study_lite_custom_css .='background-color: #fff;';
		$master_study_lite_custom_css .='}';
	}else if($master_study_lite_theme_lay == 'Without Background'){
		$master_study_lite_custom_css .='{';
			$master_study_lite_custom_css .='background-color: transparent;';
		$master_study_lite_custom_css .='}';
	}

	/*-------------- Woocommerce Button  -------------------*/
	$master_study_lite_woocommerce_button_padding_top = get_theme_mod('master_study_lite_woocommerce_button_padding_top',12);
	$master_study_lite_custom_css .='.woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .woocommerce ul.products li.product .button{';
		$master_study_lite_custom_css .='padding-top: '.esc_attr($master_study_lite_woocommerce_button_padding_top).'px; padding-bottom: '.esc_attr($master_study_lite_woocommerce_button_padding_top).'px;';
	$master_study_lite_custom_css .='}';
	

	$master_study_lite_woocommerce_button_padding_right = get_theme_mod('master_study_lite_woocommerce_button_padding_right',15);
	$master_study_lite_custom_css .='.woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .woocommerce ul.products li.product .button{';
		$master_study_lite_custom_css .='padding-left: '.esc_attr($master_study_lite_woocommerce_button_padding_right).'px; padding-right: '.esc_attr($master_study_lite_woocommerce_button_padding_right).'px;';
	$master_study_lite_custom_css .='}';

	$master_study_lite_woocommerce_button_border_radius = get_theme_mod('master_study_lite_woocommerce_button_border_radius',3);
	$master_study_lite_custom_css .='.woocommerce ul.products li.product .button, a.checkout-button.button.alt.wc-forward,.woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .woocommerce a.added_to_cart{';
		$master_study_lite_custom_css .='border-radius: '.esc_attr($master_study_lite_woocommerce_button_border_radius).'px;';
	$master_study_lite_custom_css .='}';

	$master_study_lite_related_product_enable = get_theme_mod('master_study_lite_related_product_enable',true);
	if($master_study_lite_related_product_enable == false){
		$master_study_lite_custom_css .='.related.products{';
			$master_study_lite_custom_css .='display: none;';
		$master_study_lite_custom_css .='}';
	}

	$master_study_lite_woocommerce_product_border_enable = get_theme_mod('master_study_lite_woocommerce_product_border_enable',false);
	if($master_study_lite_woocommerce_product_border_enable == false){
		$master_study_lite_custom_css .='.products li{';
			$master_study_lite_custom_css .='border: none;';
		$master_study_lite_custom_css .='}';
	}else if($master_study_lite_woocommerce_product_border_enable == true){
		$master_study_lite_custom_css .='.products li{';
			$master_study_lite_custom_css .='border: 1px solid #ccc;';
		$master_study_lite_custom_css .='}';
	}

	$master_study_lite_woocommerce_product_padding_top = get_theme_mod('master_study_lite_woocommerce_product_padding_top',0);
	$master_study_lite_custom_css .='.woocommerce ul.products li.product, .woocommerce-page ul.products li.product, .woocommerce ul.products.columns-2 li.product, .woocommerce-page ul.products.columns-2 li.product {';
		$master_study_lite_custom_css .='padding-top: '.esc_attr($master_study_lite_woocommerce_product_padding_top).'px; padding-bottom: '.esc_attr($master_study_lite_woocommerce_product_padding_top).'px !important;';
	$master_study_lite_custom_css .='}';

	$master_study_lite_woocommerce_product_padding_right = get_theme_mod('master_study_lite_woocommerce_product_padding_right',0);
	$master_study_lite_custom_css .='.woocommerce ul.products li.product, .woocommerce-page ul.products li.product, .woocommerce ul.products.columns-2 li.product, .woocommerce-page ul.products.columns-2 li.product {';
		$master_study_lite_custom_css .='padding-left: '.esc_attr($master_study_lite_woocommerce_product_padding_right).'px; padding-right: '.esc_attr($master_study_lite_woocommerce_product_padding_right).'px !important;';
	$master_study_lite_custom_css .='}';

	$master_study_lite_woocommerce_product_border_radius = get_theme_mod('master_study_lite_woocommerce_product_border_radius');
	$master_study_lite_custom_css .='.woocommerce ul.products li.product, .woocommerce-page ul.products li.product{';
		$master_study_lite_custom_css .='border-radius: '.esc_attr($master_study_lite_woocommerce_product_border_radius).'px;';
	$master_study_lite_custom_css .='}';

	$master_study_lite_woocommerce_product_box_shadow = get_theme_mod('master_study_lite_woocommerce_product_box_shadow');
	$master_study_lite_custom_css .='.woocommerce ul.products li.product, .woocommerce-page ul.products li.product{';
		$master_study_lite_custom_css .='box-shadow: '.esc_attr($master_study_lite_woocommerce_product_box_shadow).'px '.esc_attr($master_study_lite_woocommerce_product_box_shadow).'px '.esc_attr($master_study_lite_woocommerce_product_box_shadow).'px #ddd;';
	$master_study_lite_custom_css .='}';

	$master_study_lite_woo_product_sale_top_bottom_padding = get_theme_mod('master_study_lite_woo_product_sale_top_bottom_padding', 0);
	$master_study_lite_woo_product_sale_left_right_padding = get_theme_mod('master_study_lite_woo_product_sale_left_right_padding', 0);
	$master_study_lite_custom_css .='.woocommerce span.onsale{';
		$master_study_lite_custom_css .='padding-top: '.esc_attr($master_study_lite_woo_product_sale_top_bottom_padding).'px; padding-bottom: '.esc_attr($master_study_lite_woo_product_sale_top_bottom_padding).'px; padding-left: '.esc_attr($master_study_lite_woo_product_sale_left_right_padding).'px; padding-right: '.esc_attr($master_study_lite_woo_product_sale_left_right_padding).'px; display:inline-block;';
	$master_study_lite_custom_css .='}';

	$master_study_lite_woo_product_sale_border_radius = get_theme_mod('master_study_lite_woo_product_sale_border_radius',3);
	$master_study_lite_custom_css .='.woocommerce span.onsale {';
		$master_study_lite_custom_css .='border-radius: '.esc_attr($master_study_lite_woo_product_sale_border_radius).'px;';
	$master_study_lite_custom_css .='}';

	$master_study_lite_woo_product_sale_position = get_theme_mod('master_study_lite_woo_product_sale_position', 'Left');
	if($master_study_lite_woo_product_sale_position == 'Right' ){
		$master_study_lite_custom_css .='.woocommerce ul.products li.product .onsale{';
			$master_study_lite_custom_css .=' left:auto; right:0;';
		$master_study_lite_custom_css .='}';
	}elseif($master_study_lite_woo_product_sale_position == 'Left' ){
		$master_study_lite_custom_css .='.woocommerce ul.products li.product .onsale{';
			$master_study_lite_custom_css .=' left:0; right:auto;';
		$master_study_lite_custom_css .='}';
	}

	$master_study_lite_wooproduct_sale_font_size = get_theme_mod('master_study_lite_wooproduct_sale_font_size',14);
	$master_study_lite_custom_css .='.woocommerce span.onsale{';
		$master_study_lite_custom_css .='font-size: '.esc_attr($master_study_lite_wooproduct_sale_font_size).'px;';
	$master_study_lite_custom_css .='}';

	// Responsive Media
	$master_study_lite_post_date = get_theme_mod( 'master_study_lite_display_post_date',true);
	if($master_study_lite_post_date == true && get_theme_mod( 'master_study_lite_metafields_date',true) != true){
    	$master_study_lite_custom_css .='.metabox .entry-date{';
			$master_study_lite_custom_css .='display:none;';
		$master_study_lite_custom_css .='} ';
	}
    if($master_study_lite_post_date == true){
    	$master_study_lite_custom_css .='@media screen and (max-width:575px) {';
		$master_study_lite_custom_css .='.metabox .entry-date{';
			$master_study_lite_custom_css .='display:inline-block;';
		$master_study_lite_custom_css .='} }';
	}else if($master_study_lite_post_date == false){
		$master_study_lite_custom_css .='@media screen and (max-width:575px){';
		$master_study_lite_custom_css .='.metabox .entry-date{';
			$master_study_lite_custom_css .='display:none;';
		$master_study_lite_custom_css .='} }';
	}

	$master_study_lite_post_author = get_theme_mod( 'master_study_lite_display_post_author',true);
	if($master_study_lite_post_author == true && get_theme_mod( 'master_study_lite_metafields_author',true) != true){
    	$master_study_lite_custom_css .='.metabox .entry-author{';
			$master_study_lite_custom_css .='display:none;';
		$master_study_lite_custom_css .='} ';
	}
    if($master_study_lite_post_author == true){
    	$master_study_lite_custom_css .='@media screen and (max-width:575px) {';
		$master_study_lite_custom_css .='.metabox .entry-author{';
			$master_study_lite_custom_css .='display:inline-block;';
		$master_study_lite_custom_css .='} }';
	}else if($master_study_lite_post_author == false){
		$master_study_lite_custom_css .='@media screen and (max-width:575px){';
		$master_study_lite_custom_css .='.metabox .entry-author{';
			$master_study_lite_custom_css .='display:none;';
		$master_study_lite_custom_css .='} }';
	}

	$master_study_lite_post_comment = get_theme_mod( 'master_study_lite_display_post_comment',true);
	if($master_study_lite_post_comment == true && get_theme_mod( 'master_study_lite_metafields_comment',true) != true){
    	$master_study_lite_custom_css .='.metabox .entry-comments{';
			$master_study_lite_custom_css .='display:none;';
		$master_study_lite_custom_css .='} ';
	}
    if($master_study_lite_post_comment == true){
    	$master_study_lite_custom_css .='@media screen and (max-width:575px) {';
		$master_study_lite_custom_css .='.metabox .entry-comments{';
			$master_study_lite_custom_css .='display:inline-block;';
		$master_study_lite_custom_css .='} }';
	}else if($master_study_lite_post_comment == false){
		$master_study_lite_custom_css .='@media screen and (max-width:575px){';
		$master_study_lite_custom_css .='.metabox .entry-comments{';
			$master_study_lite_custom_css .='display:none;';
		$master_study_lite_custom_css .='} }';
	}

	$master_study_lite_post_time = get_theme_mod( 'master_study_lite_display_post_time',true);
	if($master_study_lite_post_time == true && get_theme_mod( 'master_study_lite_metafields_time',true) != true){
    	$master_study_lite_custom_css .='.metabox .entry-time{';
			$master_study_lite_custom_css .='display:none;';
		$master_study_lite_custom_css .='} ';
	}
    if($master_study_lite_post_time == true){
    	$master_study_lite_custom_css .='@media screen and (max-width:575px) {';
		$master_study_lite_custom_css .='.metabox .entry-time{';
			$master_study_lite_custom_css .='display:inline-block;';
		$master_study_lite_custom_css .='} }';
	}else if($master_study_lite_post_time == false){
		$master_study_lite_custom_css .='@media screen and (max-width:575px){';
		$master_study_lite_custom_css .='.metabox .entry-time{';
			$master_study_lite_custom_css .='display:none;';
		$master_study_lite_custom_css .='} }';
	}

	if($master_study_lite_post_date == false && $master_study_lite_post_author == false && $master_study_lite_post_comment == false && $master_study_lite_post_time == false){
		$master_study_lite_custom_css .='@media screen and (max-width:575px) {';
    	$master_study_lite_custom_css .='.metabox {';
			$master_study_lite_custom_css .='display:none;';
		$master_study_lite_custom_css .='} }';
	}

	$master_study_lite_metafields_date = get_theme_mod( 'master_study_lite_metafields_date',true);
	$master_study_lite_metafields_author = get_theme_mod( 'master_study_lite_metafields_author',true);
	$master_study_lite_metafields_comment = get_theme_mod( 'master_study_lite_metafields_comment',true);
	$master_study_lite_metafields_time = get_theme_mod( 'master_study_lite_metafields_time',true);
	if($master_study_lite_metafields_date == false && $master_study_lite_metafields_author == false && $master_study_lite_metafields_comment == false && $master_study_lite_metafields_time == false){
		$master_study_lite_custom_css .='@media screen and (min-width:576px) {';
    	$master_study_lite_custom_css .='.metabox {';
			$master_study_lite_custom_css .='display:none;';
		$master_study_lite_custom_css .='} }';
	}

	$master_study_lite_sidebar = get_theme_mod( 'master_study_lite_display_sidebar',true);
    if($master_study_lite_sidebar == true){
    	$master_study_lite_custom_css .='@media screen and (max-width:575px) {';
		$master_study_lite_custom_css .='#sidebar{';
			$master_study_lite_custom_css .='display:block;';
		$master_study_lite_custom_css .='} }';
	}else if($master_study_lite_sidebar == false){
		$master_study_lite_custom_css .='@media screen and (max-width:575px) {';
		$master_study_lite_custom_css .='#sidebar{';
			$master_study_lite_custom_css .='display:none;';
		$master_study_lite_custom_css .='} }';
	}

	$master_study_lite_preloader = get_theme_mod( 'master_study_lite_display_preloader',false);
	if($master_study_lite_preloader == true && get_theme_mod( 'master_study_lite_preloader',false) == false){
		$master_study_lite_custom_css .='@media screen and (min-width:575px) {';
    	$master_study_lite_custom_css .='.frame{';
			$master_study_lite_custom_css .=' visibility: hidden;';
		$master_study_lite_custom_css .='} }';
	}
    if($master_study_lite_preloader == true){
    	$master_study_lite_custom_css .='@media screen and (max-width:575px) {';
		$master_study_lite_custom_css .='.frame{';
			$master_study_lite_custom_css .='visibility:visible;';
		$master_study_lite_custom_css .='} }';
	}else if($master_study_lite_preloader == false){
		$master_study_lite_custom_css .='@media screen and (max-width:575px){';
		$master_study_lite_custom_css .='.frame{';
			$master_study_lite_custom_css .='visibility: hidden;';
		$master_study_lite_custom_css .='} }';
	}

	$master_study_lite_scroll = get_theme_mod( 'master_study_lite_display_scroll',true);
    if($master_study_lite_scroll == true){
    	$master_study_lite_custom_css .='@media screen and (max-width:575px) {';
		$master_study_lite_custom_css .='#scrollbutton{';
			$master_study_lite_custom_css .='display:block !important;';
		$master_study_lite_custom_css .='} }';
	}else if($master_study_lite_scroll == false){
		$master_study_lite_custom_css .='@media screen and (max-width:575px) {';
		$master_study_lite_custom_css .='#scrollbutton{';
			$master_study_lite_custom_css .='display:none !important;';
		$master_study_lite_custom_css .='} }';
	}

	$master_study_lite_responsive_show_back_to_top = get_theme_mod('master_study_lite_responsive_show_back_to_top',true);
	if($master_study_lite_responsive_show_back_to_top == true && get_theme_mod('master_study_lite_hide_show_scroll',true) == false){
		$master_study_lite_custom_css .='@media screen and (min-width:575px){
			#scrollbutton{';
			$master_study_lite_custom_css .='visibility:visible;';
		$master_study_lite_custom_css .='} }';
	}
	if($master_study_lite_responsive_show_back_to_top == false){
		$master_study_lite_custom_css .='@media screen and (max-width:575px){
			#scrollbutton{';
			$master_study_lite_custom_css .='visibility: hidden;';
		$master_study_lite_custom_css .='} }';
	}

	$master_study_lite_search = get_theme_mod( 'master_study_lite_display_search_category',true);
	if($master_study_lite_search == true && get_theme_mod( 'master_study_lite_search_enable_disable',true) != true){
    	$master_study_lite_custom_css .='.search-cat-box{';
			$master_study_lite_custom_css .='display:none;';
		$master_study_lite_custom_css .='} ';
	}
    if($master_study_lite_search == true){
    	$master_study_lite_custom_css .='@media screen and (max-width:575px) {';
		$master_study_lite_custom_css .='.search-cat-box{';
			$master_study_lite_custom_css .='display:block;';
		$master_study_lite_custom_css .='} }';
	}else if($master_study_lite_search == false){
		$master_study_lite_custom_css .='@media screen and (max-width:575px){';
		$master_study_lite_custom_css .='.search-cat-box{';
			$master_study_lite_custom_css .='display:none;';
		$master_study_lite_custom_css .='} }';
	}

	$master_study_lite_myaccount = get_theme_mod( 'master_study_lite_display_myaccount',true);
	if($master_study_lite_myaccount == true && get_theme_mod( 'master_study_lite_myaccount_enable_disable',true) != true){
    	$master_study_lite_custom_css .='.login-box{';
			$master_study_lite_custom_css .='display:none;';
		$master_study_lite_custom_css .='} ';
	}
    if($master_study_lite_myaccount == true){
    	$master_study_lite_custom_css .='@media screen and (max-width:575px) {';
		$master_study_lite_custom_css .='.login-box{';
			$master_study_lite_custom_css .='display:block;';
		$master_study_lite_custom_css .='} }';
	}else if($master_study_lite_myaccount == false){
		$master_study_lite_custom_css .='@media screen and (max-width:575px){';
		$master_study_lite_custom_css .='.login-box{';
			$master_study_lite_custom_css .='display:none;';
		$master_study_lite_custom_css .='} }';
	}

	// menu settings
	$master_study_lite_menu_font_size_option = get_theme_mod('master_study_lite_menu_font_size_option');
	$master_study_lite_custom_css .='#site-navigation .menu ul li a, .main-navigation .menu li a{';
		$master_study_lite_custom_css .='font-size: '.esc_attr($master_study_lite_menu_font_size_option).'px;';
	$master_study_lite_custom_css .='}';

	$master_study_lite_menu_padding = get_theme_mod('master_study_lite_menu_padding');
	$master_study_lite_custom_css .='#site-navigation .menu ul li a, .main-navigation .menu li a{';
		$master_study_lite_custom_css .='padding: '.esc_attr($master_study_lite_menu_padding).'px;';
	$master_study_lite_custom_css .='}';

	//  comment form width
	$master_study_lite_comment_form_width = get_theme_mod( 'master_study_lite_comment_form_width');
	$master_study_lite_custom_css .='#comments textarea{';
		$master_study_lite_custom_css .='width: '.esc_attr($master_study_lite_comment_form_width).'%;';
	$master_study_lite_custom_css .='}';

	$master_study_lite_title_comment_form = get_theme_mod('master_study_lite_title_comment_form', 'Leave a Reply');
	if($master_study_lite_title_comment_form == ''){
		$master_study_lite_custom_css .='#comments h2#reply-title {';
			$master_study_lite_custom_css .='display: none;';
		$master_study_lite_custom_css .='}';
	}

	$master_study_lite_comment_form_button_content = get_theme_mod('master_study_lite_comment_form_button_content', 'Post Comment');
	if($master_study_lite_comment_form_button_content == ''){
		$master_study_lite_custom_css .='#comments p.form-submit {';
			$master_study_lite_custom_css .='display: none;';
		$master_study_lite_custom_css .='}';
	}

	// featured image setting
	$master_study_lite_image_border_radius = get_theme_mod('master_study_lite_image_border_radius', 0);
	$master_study_lite_custom_css .='.box-image img, .content_box img{';
		$master_study_lite_custom_css .='border-radius: '.esc_attr($master_study_lite_image_border_radius).'%;';
	$master_study_lite_custom_css .='}';

	$master_study_lite_image_box_shadow = get_theme_mod('master_study_lite_image_box_shadow',0);
	$master_study_lite_custom_css .='.box-image img, .content_box img{';
		$master_study_lite_custom_css .='box-shadow: '.esc_attr($master_study_lite_image_box_shadow).'px '.esc_attr($master_study_lite_image_box_shadow).'px '.esc_attr($master_study_lite_image_box_shadow).'px #b5b5b5;';
	$master_study_lite_custom_css .='}';

	// Post Block
	$master_study_lite_post_block_option = get_theme_mod( 'master_study_lite_post_block_option','By Block');
    if($master_study_lite_post_block_option == 'By Without Block'){
		$master_study_lite_custom_css .='.gridbox .inner-service, .related-inner-box, .mainbox-post, .layout2, .layout1, .post_format-post-format-video,.post_format-post-format-image,.post_format-post-format-audio, .post_format-post-format-gallery, .mainbox{';
			$master_study_lite_custom_css .='border:none; margin:30px 0;';
		$master_study_lite_custom_css .='}';
	}

	// post image 
	$master_study_lite_post_featured_color = get_theme_mod('master_study_lite_post_featured_color', 'var(--first-theme-color)');
	$master_study_lite_post_featured_image = get_theme_mod('master_study_lite_post_featured_image','Image');
	if($master_study_lite_post_featured_image == 'Color'){
		$master_study_lite_custom_css .='.post-color{';
			$master_study_lite_custom_css .='background-color: '.esc_attr($master_study_lite_post_featured_color).';';
		$master_study_lite_custom_css .='}';
	}

	// featured image dimention
	$master_study_lite_post_featured_image_dimention = get_theme_mod('master_study_lite_post_featured_image_dimention', 'Default');
	$master_study_lite_post_featured_image_custom_width = get_theme_mod('master_study_lite_post_featured_image_custom_width');
	$master_study_lite_post_featured_image_custom_height = get_theme_mod('master_study_lite_post_featured_image_custom_height');
	if($master_study_lite_post_featured_image_dimention == 'Custom'){
		$master_study_lite_custom_css .='.box-image img{';
			$master_study_lite_custom_css .='width: '.esc_attr($master_study_lite_post_featured_image_custom_width).'px; height: '.esc_attr($master_study_lite_post_featured_image_custom_height).'px;';
		$master_study_lite_custom_css .='}';
	}

	// featured image dimention
	$master_study_lite_custom_post_color_width = get_theme_mod('master_study_lite_custom_post_color_width');
	$master_study_lite_custom_post_color_height = get_theme_mod('F');
	if($master_study_lite_post_featured_image == 'Color'){
		$master_study_lite_custom_css .='.post-color{';
			$master_study_lite_custom_css .='width: '.esc_attr($master_study_lite_custom_post_color_width).'px; height: '.esc_attr($master_study_lite_custom_post_color_height).'px;';
		$master_study_lite_custom_css .='}';
	}

	// site title font size
	$master_study_lite_site_title_font_size = get_theme_mod('master_study_lite_site_title_font_size');
	$master_study_lite_custom_css .='.logo .site-title{';
	$master_study_lite_custom_css .='font-size: '.esc_attr($master_study_lite_site_title_font_size).'px;';
	$master_study_lite_custom_css .='}';

	// site tagline font size
	$master_study_lite_site_tagline_font_size = get_theme_mod('master_study_lite_site_tagline_font_size');
	$master_study_lite_custom_css .='p.site-description{';
	$master_study_lite_custom_css .='font-size: '.esc_attr($master_study_lite_site_tagline_font_size).'px;';
	$master_study_lite_custom_css .='}';

	// woocommerce Product Navigation
	$master_study_lite_wooproducts_nav = get_theme_mod('master_study_lite_wooproducts_nav', 'Yes');
	if($master_study_lite_wooproducts_nav == 'No'){
		$master_study_lite_custom_css .='.woocommerce nav.woocommerce-pagination{';
			$master_study_lite_custom_css .='display: none;';
		$master_study_lite_custom_css .='}';
	}

	// site title color
	$master_study_lite_site_title_color = get_theme_mod('master_study_lite_site_title_color');
	$master_study_lite_custom_css .='.site-title a{';
		$master_study_lite_custom_css .='color: '.esc_attr($master_study_lite_site_title_color).' !important;';
	$master_study_lite_custom_css .='}';

	// site tagline color
	$master_study_lite_site_tagline_color = get_theme_mod('master_study_lite_site_tagline_color');
	$master_study_lite_custom_css .='.site-description{';
		$master_study_lite_custom_css .='color: '.esc_attr($master_study_lite_site_tagline_color).' !important;';
	$master_study_lite_custom_css .='}';
	
	// site toggle button color
	$master_study_lite_toggle_button_color = get_theme_mod('master_study_lite_toggle_button_color');
	$master_study_lite_custom_css .='.toggle-nav i{';
		$master_study_lite_custom_css .='color: '.esc_attr($master_study_lite_toggle_button_color).' !important;';
	$master_study_lite_custom_css .='}';

	//Copyright text color
	$master_study_lite_copyright_text_color = get_theme_mod('master_study_lite_copyright_text_color');
	$master_study_lite_custom_css .='.copyright-wrapper, .copyright-wrapper p a{';
		$master_study_lite_custom_css .='color: '.esc_attr($master_study_lite_copyright_text_color).';';
	$master_study_lite_custom_css .='}';

	//Copyright text Hover color
	$master_study_lite_copyright_text_hover_color = get_theme_mod('master_study_lite_copyright_text_hover_color');
	$master_study_lite_custom_css .='.copyright-wrapper, .copyright-wrapper p a:hover{';
		$master_study_lite_custom_css .='color: '.esc_attr($master_study_lite_copyright_text_hover_color).';';
	$master_study_lite_custom_css .='}';

	//Copyright background css
	$master_study_lite_copyright_text_background = get_theme_mod('master_study_lite_copyright_text_background');
	$master_study_lite_custom_css .='.copyright-wrapper{';
		$master_study_lite_custom_css .='background-color: '.esc_attr($master_study_lite_copyright_text_background).';';
	$master_study_lite_custom_css .='}';

	// menu font weight
	$master_study_lite_font_weight_option_menu = get_theme_mod( 'master_study_lite_font_weight_option_menu');
	if($master_study_lite_font_weight_option_menu != ''){
		$master_study_lite_custom_css .='#site-navigation .menu ul li a, .main-navigation .menu li a{';
			$master_study_lite_custom_css .='font-weight: '.esc_attr($master_study_lite_font_weight_option_menu).'!important;';
		$master_study_lite_custom_css .='}';
	}

	// menu text transform
	$master_study_lite_theme_lay = get_theme_mod( 'master_study_lite_menu_text_tranform','Uppercase');
    if($master_study_lite_theme_lay == 'Uppercase'){
		$master_study_lite_custom_css .='#site-navigation .menu ul li a, .main-navigation .menu li a{';
			$master_study_lite_custom_css .='text-transform: uppercase;';
		$master_study_lite_custom_css .='}';
	}else if($master_study_lite_theme_lay == 'Lowercase'){
		$master_study_lite_custom_css .='#site-navigation .menu ul li a, .main-navigation .menu li a{';
			$master_study_lite_custom_css .='text-transform: lowercase;';
		$master_study_lite_custom_css .='}';
	}
	else if($master_study_lite_theme_lay == 'Capitalize'){
		$master_study_lite_custom_css .='#site-navigation .menu ul li a, .main-navigation .menu li a{';
			$master_study_lite_custom_css .='text-transform: capitalize;';
		$master_study_lite_custom_css .='}';
	}

	// menu color
	$master_study_lite_menu_color = get_theme_mod('master_study_lite_menu_color');

	$master_study_lite_custom_css .='.primary-navigation a, .primary-navigation ul li a, #site-navigation li a{';
			$master_study_lite_custom_css .='color: '.esc_attr($master_study_lite_menu_color).' !important;';
	$master_study_lite_custom_css .='}';

// Sub menu color
	$master_study_lite_sub_menu_color = get_theme_mod('master_study_lite_sub_menu_color');

	$master_study_lite_custom_css .='.primary-navigation ul.sub-menu a, .primary-navigation ul.sub-menu li a, #site-navigation ul.sub-menu li a, .primary-navigation ul.children a, .primary-navigation ul.children li a, #site-navigation ul.children li a{';
			$master_study_lite_custom_css .='color: '.esc_attr($master_study_lite_sub_menu_color).' !important;';
	$master_study_lite_custom_css .='}';

// menu hover color
	$master_study_lite_menu_hover_color = get_theme_mod('master_study_lite_menu_hover_color');

	$master_study_lite_custom_css .='.primary-navigation a:hover, .primary-navigation ul li a:hover, .primary-navigation .current_page_item > a:hover, .primary-navigation .current-menu-item > a:hover, .primary-navigation .current_page_ancestor > a:hover, #site-navigation li a:hover{';
			$master_study_lite_custom_css .='color: '.esc_attr($master_study_lite_menu_hover_color).' !important;';
	$master_study_lite_custom_css .='}';

// Sub menu hover color
	$master_study_lite_sub_menu_hover_color = get_theme_mod('master_study_lite_sub_menu_hover_color');

	$master_study_lite_custom_css .='.primary-navigation ul.sub-menu a:hover, .primary-navigation ul.sub-menu li a:hover, .primary-navigation .current_page_item > a:hover, .primary-navigation .current-menu-item > a:hover, .primary-navigation .current_page_ancestor > a:hover, #site-navigation ul.sub-menu li a:hover, .primary-navigation ul.children a:hover, .primary-navigation ul.children li a:hover, #site-navigation ul.children li a:hover{';
			$master_study_lite_custom_css .='color: '.esc_attr($master_study_lite_sub_menu_hover_color).' !important;';
	$master_study_lite_custom_css .='}';	

// Menu Item Hover Style	

	$master_study_lite_menus_item = get_theme_mod( 'master_study_lite_menus_item_style','None');
    if($master_study_lite_menus_item == 'None'){
		$master_study_lite_custom_css .='#site-navigation .menu ul li a:hover, .main-navigation .menu li a:hover{';
			$master_study_lite_custom_css .='';
		$master_study_lite_custom_css .='}';
	}else if($master_study_lite_menus_item == 'Zoom In'){
		$master_study_lite_custom_css .='#site-navigation .menu ul li a:hover, .main-navigation .menu li a:hover{';
			$master_study_lite_custom_css .='transition: all 0.3s ease-in-out !important; transform: scale(1.2) !important;';
		$master_study_lite_custom_css .='}';
	}	

	/*----------------- Slider -----------------*/

	$master_study_lite_slider_hide = get_theme_mod('master_study_lite_slider_hide', false);
	if($master_study_lite_slider_hide == false){
		$master_study_lite_custom_css .='.page-template-home-page .top-header{';
			$master_study_lite_custom_css .='position: static;';
		$master_study_lite_custom_css .='}';
		$master_study_lite_custom_css .='.top-header{';
			$master_study_lite_custom_css .='margin-top: 0;';
		$master_study_lite_custom_css .='}';
		$master_study_lite_custom_css .='.page-template-home-page .logo .site-title a, .page-template-home-page .logo p.site-description{';
			$master_study_lite_custom_css .='color: var(--first-theme-color);';
		$master_study_lite_custom_css .='}';
	}

	/*--------------------------- Slider Opacity -------------------*/
	$master_study_lite_slider_layout = get_theme_mod( 'master_study_lite_slider_opacity_color', '0.6');
	if($master_study_lite_slider_layout == '0'){
		$master_study_lite_custom_css .='#slider .slider-overlay{';
			$master_study_lite_custom_css .='opacity:0';
		$master_study_lite_custom_css .='}';
		}else if($master_study_lite_slider_layout == '0.1'){
		$master_study_lite_custom_css .='#slider .slider-overlay{';
			$master_study_lite_custom_css .='opacity:0.1';
		$master_study_lite_custom_css .='}';
		}else if($master_study_lite_slider_layout == '0.2'){
		$master_study_lite_custom_css .='#slider .slider-overlay{';
			$master_study_lite_custom_css .='opacity:0.2';
		$master_study_lite_custom_css .='}';
		}else if($master_study_lite_slider_layout == '0.3'){
		$master_study_lite_custom_css .='#slider .slider-overlay{';
			$master_study_lite_custom_css .='opacity:0.3';
		$master_study_lite_custom_css .='}';
		}else if($master_study_lite_slider_layout == '0.4'){
		$master_study_lite_custom_css .='#slider .slider-overlay{';
			$master_study_lite_custom_css .='opacity:0.4';
		$master_study_lite_custom_css .='}';
		}else if($master_study_lite_slider_layout == '0.5'){
		$master_study_lite_custom_css .='#slider .slider-overlay{';
			$master_study_lite_custom_css .='opacity:0.5';
		$master_study_lite_custom_css .='}';
		}else if($master_study_lite_slider_layout == '0.6'){
		$master_study_lite_custom_css .='#slider .slider-overlay{';
			$master_study_lite_custom_css .='opacity:0.6';
		$master_study_lite_custom_css .='}';
		}else if($master_study_lite_slider_layout == '0.7'){
		$master_study_lite_custom_css .='#slider .slider-overlay{';
			$master_study_lite_custom_css .='opacity:0.7';
		$master_study_lite_custom_css .='}';
		}else if($master_study_lite_slider_layout == '0.8'){
		$master_study_lite_custom_css .='#slider .slider-overlay{';
			$master_study_lite_custom_css .='opacity:0.8';
		$master_study_lite_custom_css .='}';
		}else if($master_study_lite_slider_layout == '0.9'){
		$master_study_lite_custom_css .='#slider .slider-overlay{';
			$master_study_lite_custom_css .='opacity:0.9';
		$master_study_lite_custom_css .='}';
		}	

   //Footer Style 
   $master_study_lite_theme_lay = get_theme_mod( 'master_study_lite_footer_template','master_study_lite-footer-one');
   if($master_study_lite_theme_lay == 'master_study_lite-footer-one'){
	   $master_study_lite_custom_css .='.footer-wp{';
		   $master_study_lite_custom_css .='';
	   $master_study_lite_custom_css .='}';

   }else if($master_study_lite_theme_lay == 'master_study_lite-footer-two'){
	   $master_study_lite_custom_css .='.footer-wp {';
		   $master_study_lite_custom_css .='background: #E3F2FD !important;';
	   $master_study_lite_custom_css .='}';
	   $master_study_lite_custom_css .='.footer-wp p,.footer-wp span,.footer-wp li a,.footer-wp #wp-calendar caption,.footer-wp #wp-calendar td,.footer-wp #wp-calendar th, .footer-wp, .footer-wp h3, .footer-wp a.rsswidget, .footer-wp #wp-calendar a, .copyright a, .footer-wp .custom_details, .footer-wp ins span, .footer-wp .tagcloud a, .main-inner-box span.entry-date a, nav.woocommerce-MyAccount-navigation ul li:hover a, .footer-wp ul li a, .footer-wp table, .footer-wp th, .footer-wp td, .footer-wp caption, #sidebar caption,.footer-wp nav.wp-calendar-nav a,.footer-wp .search-form .search-field, .footer-wp .rssSummary, .footer-wp ul li{';
		   $master_study_lite_custom_css .='color:#000 !important;';
	   $master_study_lite_custom_css .='}';
	   $master_study_lite_custom_css .='.footer-wp p{';
		   $master_study_lite_custom_css .='color:#000 !important;';
	   $master_study_lite_custom_css .='}';
	   $master_study_lite_custom_css .='.footer-wp ul li::before{';
		   $master_study_lite_custom_css .='background:#000;';
	   $master_study_lite_custom_css .='}';
	   $master_study_lite_custom_css .='.footer-wp table, .footer-wp th, .footer-wp td,.footer-wp.search-form .search-field,.footer-wp .tagcloud a{';
		   $master_study_lite_custom_css .='border: 1px solid #000;';
	   $master_study_lite_custom_css .='}';

   }else if($master_study_lite_theme_lay == 'master_study_lite-footer-three'){
	   $master_study_lite_custom_css .='.footer-wp {';
		   $master_study_lite_custom_css .='background: #0A0A1F !important;;';
	   $master_study_lite_custom_css .='}';
   }
   else if($master_study_lite_theme_lay == 'master_study_lite-footer-four'){
	   $master_study_lite_custom_css .='.footer-wp {';
		   $master_study_lite_custom_css .='background: #F5F5DC !important;;';
	   $master_study_lite_custom_css .='}';
	   $master_study_lite_custom_css .='.footer-wp p,.footer-wp span,.footer-wp li a,.footer-wp #wp-calendar caption,.footer-wp #wp-calendar td,.footer-wp #wp-calendar th, .footer-wp, .footer-wp h3, .footer-wp a.rsswidget, .footer-wp #wp-calendar a, .copyright a, .footer-wp .custom_details, .footer-wp ins span, .footer-wp .tagcloud a, .main-inner-box span.entry-date a, nav.woocommerce-MyAccount-navigation ul li:hover a, .footer-wp ul li a, .footer-wp table, .footer-wp th, .footer-wp td, .footer-wp caption, #sidebar caption,.footer-wp nav.wp-calendar-nav a,.footer-wp .search-form .search-field, .footer-wp .rssSummary, .footer-wp ul li{';
		   $master_study_lite_custom_css .='color:#000 !important;';
	   $master_study_lite_custom_css .='}';
	   $master_study_lite_custom_css .='.footer-wp p{';
		   $master_study_lite_custom_css .='color:#000 !important;';
	   $master_study_lite_custom_css .='}';
	   $master_study_lite_custom_css .='.footer-wp ul li::before{';
		   $master_study_lite_custom_css .='background:#000;';
	   $master_study_lite_custom_css .='}';
	   $master_study_lite_custom_css .='.footer-wp table, .footer-wp th, .footer-wp td,.footer-wp.search-form .search-field,.footer-wp .tagcloud a{';
		   $master_study_lite_custom_css .='border: 1px solid #000;';
	   $master_study_lite_custom_css .='}';
   }
   else if($master_study_lite_theme_lay == 'master_study_lite-footer-five'){
   $master_study_lite_custom_css .='.footer-wp {';
	   $master_study_lite_custom_css .='background: #333333 !important;;';
   $master_study_lite_custom_css .='}';
  }	
  
	//Footer Social Icon Alignment
	$master_study_lite_footer_icon_alignment = get_theme_mod( 'master_study_lite_footer_icon_alignment','center');
    if($master_study_lite_footer_icon_alignment == 'left'){
		$master_study_lite_custom_css .='footer .socialicons{';
			$master_study_lite_custom_css .='text-align:left !important;';
		$master_study_lite_custom_css .='}';
	}else if($master_study_lite_footer_icon_alignment == 'center'){
		$master_study_lite_custom_css .='footer .socialicons{';
			$master_study_lite_custom_css .='text-align:center !important;';
		$master_study_lite_custom_css .='}';
	}else if($master_study_lite_footer_icon_alignment == 'right'){
		$master_study_lite_custom_css .='footer .socialicons{';
			$master_study_lite_custom_css .='text-align:right !important;';
		$master_study_lite_custom_css .='}';
	}	

	//Footer icon color
	$master_study_lite_footer_icon_color_option = get_theme_mod('master_study_lite_footer_icon_color_option');
	$master_study_lite_custom_css .='footer .socialicons a{';
			$master_study_lite_custom_css .='color: '.esc_attr($master_study_lite_footer_icon_color_option).' !important;';
	$master_study_lite_custom_css .='}';  
	