<?php
/**
 * The template part for displaying gallery post
 * @package Master Study Lite
 * @subpackage master_study_lite
 * @since 1.0
 */

$master_study_lite_archive_year  = get_the_time('Y'); 
$master_study_lite_archive_month = get_the_time('m'); 
$master_study_lite_archive_day   = get_the_time('d');

?>
<article id="post-<?php the_ID(); ?>" <?php post_class('inner-service'); ?>>
  <div class="box-image">
    <?php
      if ( ! is_single() ) {

        // If not a single post, highlight the gallery.
        if ( get_post_gallery() ) {
          echo '<div class="entry-gallery">';
            echo ( get_post_gallery() );
          echo '</div>';
        };

      };
    ?>
  </div>
  <h2><a href="<?php echo esc_url( get_permalink() ); ?>" title="<?php echo the_title_attribute(); ?>"><?php the_title();?><span class="screen-reader-text"><?php the_title(); ?></span></a></h2>
  <?php if( get_theme_mod('master_study_lite_metafields_date', true) != '' || get_theme_mod('master_study_lite_metafields_author', true) != '' || get_theme_mod('master_study_lite_metafields_comment', true) != '' || get_theme_mod('master_study_lite_metafields_time', true) != '' &&  get_theme_mod('master_study_lite_display_post_date', true) != '' || get_theme_mod('master_study_lite_display_post_author', true) != '' || get_theme_mod('master_study_lite_display_post_comment', true) != '' || get_theme_mod('master_study_lite_display_post_time', true) != ''){ ?>
      <div class="metabox mb-3">
        <?php if( get_theme_mod( 'master_study_lite_metafields_date',true) != '' || get_theme_mod( 'master_study_lite_display_post_date',true) != '') { ?>
          <span class="entry-date me-1"><i class="<?php echo esc_attr(get_theme_mod('master_study_lite_post_date_icon','far fa-calendar-alt')); ?> me-1"></i> <a href="<?php echo esc_url( get_day_link( $master_study_lite_archive_year, $master_study_lite_archive_month, $master_study_lite_archive_day)); ?>"><?php echo esc_html( get_the_date() ); ?><span class="screen-reader-text"><?php echo esc_html( get_the_date() ); ?></span></a></span><span class="ms-1"><?php echo esc_html( get_theme_mod('master_study_lite_blog_post_meta_seperator','|') ); ?></span>
        <?php }?>
        <?php if( get_theme_mod( 'master_study_lite_metafields_author',true) != '' || get_theme_mod( 'master_study_lite_display_post_author',true) != '') { ?>
          <span class="entry-author mx-1"><i class="<?php echo esc_attr(get_theme_mod('master_study_lite_post_author_icon','fas fa-user')); ?> me-1"></i> <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' )) ); ?>"><?php the_author(); ?><span class="screen-reader-text"><?php the_title(); ?></span></a></span><span class="ms-1"><?php echo esc_html( get_theme_mod('master_study_lite_blog_post_meta_seperator','|') ); ?></span>
        <?php }?>
        <?php if( get_theme_mod( 'master_study_lite_metafields_comment',true) != '' || get_theme_mod( 'master_study_lite_display_post_comment',true) != '') { ?>
          <span class="entry-comments mx-1"><i class="<?php echo esc_attr(get_theme_mod('master_study_lite_post_comment_icon','fas fa-comments')); ?> me-1"></i> <?php comments_number( __('0 Comment', 'master-study-lite'), __('0 Comments', 'master-study-lite'), __('% Comments', 'master-study-lite') ); ?></span><span class="ms-1"><?php echo esc_html( get_theme_mod('master_study_lite_blog_post_meta_seperator','|') ); ?></span>
        <?php }?>
        <?php if( get_theme_mod( 'master_study_lite_metafields_time',true) != '' || get_theme_mod( 'master_study_lite_display_post_time',true) != '') { ?>
          <span class="entry-time mx-1"><i class="<?php echo esc_attr(get_theme_mod('master_study_lite_post_time_icon','fas fa-clock')); ?> me-1"></i> <?php echo esc_html( get_the_time() ); ?></span>
        <?php }?>
        <?php echo esc_html (master_study_lite_edit_link()); ?>
      </div>
    <?php }?>
  <div class="new-text">
    <?php $master_study_lite_theme_lay = get_theme_mod( 'master_study_lite_content_settings','Excerpt');
    if($master_study_lite_theme_lay == 'Content'){ ?>
      <?php the_content(); ?>
    <?php }
    if($master_study_lite_theme_lay == 'Excerpt'){ ?>
      <?php if(get_the_excerpt()) { ?>
        <?php $master_study_lite_excerpt = get_the_excerpt(); echo esc_html( master_study_lite_string_limit_words( $master_study_lite_excerpt, esc_attr(get_theme_mod('master_study_lite_post_excerpt_number','30')))); ?> <?php echo esc_html( get_theme_mod('master_study_lite_post_discription_suffix','[...]') ); ?>
      <?php }?>
    <?php }?>
  </div>
  <?php if( get_theme_mod('master_study_lite_button_text','Read More') != ''){ ?>
    <div class="postbtn mt-4 text-start">
      <a href="<?php the_permalink(); ?>"><?php echo esc_html(get_theme_mod('master_study_lite_button_text','Read More'));?><span class="screen-reader-text"><?php echo esc_html(get_theme_mod('master_study_lite_button_text','Read More'));?></span></a>
    </div>
  <?php }?>
</article>