<?php
/**
 * The Sidebar containing the main widget areas.
 * @package Master Study Lite
 */
?>
<div id="sidebar">    
    <?php if ( ! dynamic_sidebar( 'sidebar-1' ) ) : ?>
        <aside id="search" class="widget" role="complementary" aria-label="<?php esc_attr_e( 'firstsidebar', 'master-study-lite' ); ?>">
            <h3 class="widget-title"><?php esc_html_e( 'Search', 'master-study-lite' ); ?></h3>
            <?php get_search_form(); ?>
        </aside>
        <aside id="categories-dropdown" class="widget" role="complementary" aria-label="<?php esc_attr_e( 'secondsidebar', 'master-study-lite' ); ?>">
            <h3 class="widget-title"><?php esc_html_e( 'Dropdown Categories', 'master-study-lite' ); ?></h3>
            <ul>
                <?php wp_dropdown_categories('title_li=');  ?>
            </ul>
        </aside>
        <aside role="complementary" aria-label="<?php esc_attr_e( 'thirdsidebar', 'master-study-lite' ); ?>" id="archives" class="widget">
            <h3 class="widget-title"><?php esc_html_e( 'Archives', 'master-study-lite' ); ?></h3>
            <ul>
                <?php wp_get_archives( array( 'type' => 'monthly' ) ); ?>
            </ul>
        </aside>
        <aside role="complementary" aria-label="<?php esc_attr_e( 'forthsidebar', 'master-study-lite' ); ?>" id="meta" class="widget">
            <h3 class="widget-title"><?php esc_html_e( 'Meta', 'master-study-lite' ); ?></h3>
            <ul>
                <?php wp_register(); ?>
                <li><?php wp_loginout(); ?></li>
                <?php wp_meta(); ?>
            </ul>
        </aside>
        <aside id="tag-cloud" class="widget" role="complementary" aria-label="<?php esc_attr_e( 'fifthsidebar', 'master-study-lite' ); ?>">
            <h3 class="widget-title"><?php esc_html_e( 'Tag Cloud', 'master-study-lite' ); ?></h3>
            <ul>
                <?php wp_tag_cloud('title_li=');  ?>
            </ul>
        </aside>
    <?php endif; // end sidebar widget area ?>  
</div>