<?php
/**
 * Template Name: Custom Home Page
 */

get_header(); 

?>

<main role="main" id="skip_content">
  <?php do_action( 'master_study_lite_above_slider' ); ?>

  <?php 
    $master_study_lite_number = get_theme_mod('master_study_lite_slide_number');
    if($master_study_lite_number != ''){
  ?>
  <?php if ( get_theme_mod( 'master_study_lite_slider_hide', false ) ) { ?>
    <section id="slider" class="mw-100 m-auto p-0 position-relative">
      <div id="carouselExampleIndicators" class="carousel slide carousel-fade" data-bs-ride="carousel" data-type="multi" data-interval="false" data-bs-pause="false">
        <div class="carousel-inner" role="listbox">
          <?php for ($master_study_lite_i=1; $master_study_lite_i<=$master_study_lite_number; $master_study_lite_i++) {?>
            <div <?php if($master_study_lite_i == 1){echo 'class="carousel-item active"';} else{ echo 'class="carousel-item"';}?>>
              <?php if ( get_theme_mod('master_study_lite_slider_bg_image'.$master_study_lite_i) != "" ) {?>
                <div class="slider-img-box position-relative">
                  <img class="slider-banner-img" src="<?php echo esc_url(get_theme_mod('master_study_lite_slider_bg_image'.$master_study_lite_i)); ?>">
                  <div class="slider-overlay position-absolute"></div>
                </div>
              <?php } else { ?>
                <div class="slider-bg"></div>
              <?php } ?>
              <div class="container">
                <div class="carousel-caption">
                  <div class="inner_carousel text-center">
                    <?php if(get_theme_mod('master_study_lite_slider_small_title'.$master_study_lite_i) != ''){ ?>
                      <h1 class="slider-small-title text-capitalize mb-1 pb-0"><?php echo esc_html(get_theme_mod('master_study_lite_slider_small_title'.$master_study_lite_i)); ?></h1>
                    <?php } ?>
                    <?php if(get_theme_mod('master_study_lite_slider_title'.$master_study_lite_i) != ''){ ?>
                      <h1 class="slider-title text-capitalize mb-3 pb-0"><?php echo esc_html(get_theme_mod('master_study_lite_slider_title'.$master_study_lite_i)); ?></h1>
                    <?php } ?>
                    <?php if(get_theme_mod('master_study_lite_slider_desc_text'.$master_study_lite_i) != ''){ ?>
                      <p class="slider-desc mb-4 text-capitalize"><?php echo esc_html(get_theme_mod('master_study_lite_slider_desc_text'.$master_study_lite_i)); ?></p>
                    <?php } ?>
                    <?php if ( get_theme_mod('master_study_lite_slider_btn_text'.$master_study_lite_i) != '' ) {?>
                      <div class ="slider-btn pt-2 hover-filled-slide-down">
                        <a class="text-capitalize" href="<?php echo esc_url(get_theme_mod('master_study_lite_slider_btn_url'.$master_study_lite_i,false));?>"><?php echo esc_html(get_theme_mod('master_study_lite_slider_btn_text'.$master_study_lite_i));?></a>
                      </div>
                    <?php }?>
                  </div>
                </div>
              </div>
            </div>
          <?php } ?>
        </div>
        <div class="slider-indicator carousel-indicators">
          <div class="slider-dots">
            <?php for ($master_study_lite_i = 1; $master_study_lite_i <= $master_study_lite_number; $master_study_lite_i++) { ?>
              <button type="button"
                data-bs-target="#carouselExampleIndicators"
                data-bs-slide-to="<?php echo esc_html($master_study_lite_i - 1); ?>"
                class="<?php echo $master_study_lite_i == 1 ? 'active' : ''; ?>">
              </button>
            <?php } ?>
          </div>
        </div>
      </div>  
      <div class="clearfix"></div>
    </section>
  <?php }}?>
  <?php do_action( 'master_study_lite_below_slider' ); ?>

  <!-- Faculties Section -->
  <?php if( get_theme_mod( 'master_study_lite_section_title') != '' || get_theme_mod( 'master_study_lite_section_small_text') != '') { ?>
    <section id="faculties-sec" class="py-4 mb-5">
      <div class="container">
        <div class="heading-box text-center position-relative">
          <?php if( get_theme_mod( 'master_study_lite_section_title') != '') { ?>
            <h2 class="section-heading pb-2 px-3 text-uppercase"><?php echo esc_html(get_theme_mod('master_study_lite_section_title'));?></h2>  
          <?php } ?>
        </div>
        <div class="row pt-4">
          <?php for ($master_study_lite_j=1; $master_study_lite_j<=3; $master_study_lite_j++) {?>
            <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-4 col-12 mb-3">
              <div class="faculties-main-box">
                <?php if ( get_theme_mod('master_study_lite_faculties_image'.$master_study_lite_j) != '') {?>
                  <img class="faculties-img" src="<?php echo esc_url(get_theme_mod('master_study_lite_faculties_image'.$master_study_lite_j)); ?>">
                <?php } ?>
                <?php if( get_theme_mod( 'master_study_lite_member_name'.$master_study_lite_j) != '' || get_theme_mod( 'master_study_lite_add_designation'.$master_study_lite_j) != '' || get_theme_mod( 'master_study_lite_add_description'.$master_study_lite_j) != '') { ?>
                  <div class="faculties-content p-3">
                    <?php if(get_theme_mod('master_study_lite_member_name'.$master_study_lite_j) != ''){ ?>
                      <a href="<?php echo esc_url(get_theme_mod('master_study_lite_member_name_url' .$master_study_lite_j));?>" class="member-name text-capitalize pb-1"><?php echo esc_html(get_theme_mod('master_study_lite_member_name' .$master_study_lite_j));?>
                      </a>
                    <?php } ?>
                    <?php if(get_theme_mod('master_study_lite_add_designation'.$master_study_lite_j) != ''){ ?>
                      <p class="designation text-uppercase pb-3"><?php echo esc_html(get_theme_mod('master_study_lite_add_designation'.$master_study_lite_j)); ?></p>
                    <?php } ?>
                    <?php if(get_theme_mod('master_study_lite_add_description'.$master_study_lite_j) != ''){ ?>
                      <p class="faculties-des"><?php echo esc_html(get_theme_mod('master_study_lite_add_description'.$master_study_lite_j)); ?></p>
                    <?php } ?>
                  </div>
                <?php }?>
              </div>
            </div>
          <?php }?>
        </div>
      </div>
    </section>
  <?php }?>

  <div class="container front-page-content mt-4">
    <?php while ( have_posts() ) : the_post(); ?>
      <div class="new-text"><?php the_content(); ?></div>
    <?php endwhile; // end of the loop. ?>
  </div>
</main>

<?php get_footer(); ?>