<?php

add_action( 'admin_menu', 'master_study_lite_gettingstarted' );
function master_study_lite_gettingstarted() {
	add_theme_page( esc_html__('About Theme', 'master-study-lite'), esc_html__('Theme Demo Import', 'master-study-lite'), 'edit_theme_options', 'master-study-lite-guide-page', 'master_study_lite_guide');
}

function master_study_lite_admin_theme_style() {
   wp_enqueue_style('master-study-lite-custom-admin-style', esc_url(get_template_directory_uri()) . '/inc/dashboard/get_started_info.css');
}
add_action('admin_enqueue_scripts', 'master_study_lite_admin_theme_style');

function master_study_lite_notice(){
    global $pagenow;
    if ( is_admin() && ('themes.php' == $pagenow) && isset( $_GET['activated'] ) ) {?>
    <div class="notice notice-success is-dismissible getting_started activation-notice">
		<div class="notice-info">
			<div class="notice-image">
				<img style="width: 100%;max-width: 320px;line-height: 40px;display: inline-block;vertical-align: top;" src="<?php echo esc_url(get_stylesheet_directory_uri()) .'/screenshot.png'; ?>" />
			</div>
			<div class="notice-content">
				<h2><?php esc_html_e( 'Thanks For Installing Master Study Lite, You Rock!', 'master-study-lite' ) ?> </h2>
				<p><?php esc_html_e( 'Take benefit of a variety of features, functionalities, elements, and an exclusive set of customization options to build your own professional charity website. Please Click on the link below to know the theme setup information.', 'master-study-lite' ) ?></p>
				<div style="display: grid;">
					<a class="button notice-btn" href="<?php echo esc_url( admin_url( 'themes.php?page=master-study-lite-guide-page' )); ?>"><?php esc_html_e( 'Get Started With Theme Demo Import', 'master-study-lite' ) ?></a>
					<a class="button notice-btn" target="_blank" href="<?php echo esc_url( MASTER_STUDY_LITE_LIVE_DEMO ); ?>"><?php esc_html_e('Pro Demo', 'master-study-lite') ?></a>
					<a  class="button notice-btn" target="_blank" href="<?php echo esc_url( MASTER_STUDY_LITE_BUY_PRO ); ?>"><?php esc_html_e('Upgrade To Pro', 'master-study-lite') ?></a>
					<a  class="button notice-btn" target="_blank" href="<?php echo esc_url( MASTER_STUDY_LITE_FREE_DOC ); ?>"><?php esc_html_e('Free Doc', 'master-study-lite') ?></a>
				</div>

			</div>
		</div>
	</div>
	<?php }
}
add_action('admin_notices', 'master_study_lite_notice');

/**
 * Theme Info Page
 */
function master_study_lite_guide() {

	// Theme info
	$master_study_lite_return = add_query_arg( array()) ;
	$master_study_lite_theme = wp_get_theme( 'master-study-lite' ); ?>

	<div class="wrap getting-started">
		<div class="getting-started__header">
		    <div>
                <h2 class="tgmpa-notice-warning"></h2>
            </div>
			<div class="row">
				<div class="col-md-5 intro">
					<div class="pad-box">
						<h2><?php esc_html_e( 'Welcome to Master Study Lite', 'master-study-lite' ); ?></h2>
						<p><?php esc_html_e( 'Version: ', 'master-study-lite' ); ?><?php echo esc_html($master_study_lite_theme['Version']);?></p>
						<span class="intro__version"><?php esc_html_e( 'Congratulations! You are about to use the most easy to use and flexible WordPress theme.', 'master-study-lite' ); ?>
						</span>
						<div class="powered-by">
							<p><strong><?php esc_html_e( 'Theme created by Buy WP Templates', 'master-study-lite' ); ?></strong></p>
							<p>
								<img class="logo" src="<?php echo esc_url(get_template_directory_uri() . '/inc/dashboard/media/theme-logo.png'); ?>"/>
							</p>
							<div class="demo-content">
								<?php
									/* Demo Import */
									require get_parent_theme_file_path( '/inc/dashboard/demo-content.php' );
								?>
							</div>
						</div>
					</div>
				</div>
				<div class="col-md-7">
					<div class="pro-links">
				    	<a href="<?php echo esc_url( MASTER_STUDY_LITE_LIVE_DEMO ); ?>" target="_blank"><?php esc_html_e('Live Demo', 'master-study-lite'); ?></a>
						<a href="<?php echo esc_url( MASTER_STUDY_LITE_BUY_PRO ); ?>" target="_blank"><?php esc_html_e('Buy Pro', 'master-study-lite'); ?></a>
						<a href="<?php echo esc_url( MASTER_STUDY_LITE_PRO_DOC ); ?>" target="_blank"><?php esc_html_e('Pro Documentation', 'master-study-lite'); ?></a>
					</div>
					<div class="install-plugins">
						<img src="<?php echo esc_url(get_template_directory_uri() . '/inc/dashboard/media/responsive1.png'); ?>" alt="<?php echo esc_attr( 'responsive-image', 'master-study-lite'); ?>" />
					</div>
				</div>
			</div>
			<h2 class="tg-docs-section intruction-title" id="section-4"><?php esc_html_e( '1) Setup Master Study Lite Theme', 'master-study-lite' ); ?></h2>
			<div class="row">
					<div class="theme-instruction-block col-md-7">
						<div class="pad-box">
		           	<p><?php esc_html_e( 'The Master Study WordPress Theme is a powerful, feature-rich solution designed specifically for educational institutions, online courses, and academic professionals. Whether youre offering masters degree programs, online masters programs, or specialized courses in fields like business administration, computer science, data science, engineering, and more, this theme provides a seamless and engaging learning experience. Built with flexibility in mind, it caters to graduate programs, postgraduate study, and even distance learning masters options, ensuring that institutions can effectively deliver education in any format. The theme includes an intuitive Learning Management System (LMS) that allows institutions to create structured courses, add quizzes, manage student dashboards, and provide instructor profiles. It fully supports coursework-based masters, thesis-based masters, and executive masters programs, making it ideal for universities, training academies, and professional education platforms. With built-in payment gateways, institutions can handle course enrollments and purchases effortlessly, providing a smooth user experience. Visually, the Master Study theme is designed for clarity and professionalism, featuring clean typography, responsive layouts, and high-quality media integration. It offers customizable colors, interactive video support, and seamless navigation, ensuring an immersive learning environment. Institutions offering MBA programs, dual degree programs, or accelerated masters programs will benefit from its polished structure, which enhances credibility, engagement, and student retention.', 'master-study-lite' ); ?><p><br>
				        	<ol>
							   <li><?php esc_html_e( 'Start','master-study-lite'); ?> <a target="_blank" href="<?php echo esc_url( admin_url('customize.php') ); ?>"><?php esc_html_e( 'Customizing','master-study-lite'); ?></a> <?php esc_html_e( 'your website.','master-study-lite'); ?> </l>
							   <li><?php esc_html_e( 'Master Study Lite','master-study-lite'); ?> <a target="_blank" href="<?php echo esc_url( MASTER_STUDY_LITE_FREE_DOC ); ?>"><?php esc_html_e( 'Documentation','master-study-lite'); ?></a> </li>
						   </ol>
	         </div>
	      </div>
				 <div class="col-md-5">
						<div class="pad-box">
								<img class="logo" src="<?php echo esc_url(get_template_directory_uri() . '/inc/dashboard/media/screenshot.png'); ?>"/>
						</div>
						
	      </div>
      </div>
			  <div class="col-md-12 text-block">
					<h2 class="dashboard-install-title"><?php esc_html_e( '2) Premium Theme Information.','master-study-lite'); ?></h2>
				   	<div class="row">
						<div class="col-md-7">
							<img src="<?php echo esc_url(get_template_directory_uri() . '/inc/dashboard/media/responsive.png'); ?>" alt="<?php echo esc_attr( 'responsive-image', 'master-study-lite'); ?>">
							<div class="pad-box">
								<h3><?php esc_html_e( 'Pro Theme Description','master-study-lite'); ?></h3>
                    			<p class="pad-box-p"><?php esc_html_e( 'The Master Study WordPress Theme is a powerful, feature-rich solution designed specifically for educational institutions, online courses, and academic professionals. Whether youre offering masters degree programs, online masters programs, or specialized courses in fields like business administration, computer science, data science, engineering, and more, this theme provides a seamless and engaging learning experience. Built with flexibility in mind, it caters to graduate programs, postgraduate study, and even distance learning masters options, ensuring that institutions can effectively deliver education in any format. The theme includes an intuitive Learning Management System (LMS) that allows institutions to create structured courses, add quizzes, manage student dashboards, and provide instructor profiles. It fully supports coursework-based masters, thesis-based masters, and executive masters programs, making it ideal for universities, training academies, and professional education platforms. With built-in payment gateways, institutions can handle course enrollments and purchases effortlessly, providing a smooth user experience. Visually, the Master Study theme is designed for clarity and professionalism, featuring clean typography, responsive layouts, and high-quality media integration. It offers customizable colors, interactive video support, and seamless navigation, ensuring an immersive learning environment. Institutions offering MBA programs, dual degree programs, or accelerated masters programs will benefit from its polished structure, which enhances credibility, engagement, and student retention.', 'master-study-lite' ); ?><p>
	                    	</div>
						</div>
						<div class="col-md-5 install-plugin-right">
							<div class="pad-box">
								<h3><?php esc_html_e( 'Pro Theme Features','master-study-lite'); ?></h3>
								<div class="dashboard-install-benefit">
									<ul>
										<li><?php esc_html_e( 'Theme options using Customizer API','master-study-lite'); ?></li>
										<li><?php esc_html_e( 'Responsive design','master-study-lite'); ?></li>
										<li><?php esc_html_e( 'Site Icon and Logo option','master-study-lite'); ?></li>
										<li><?php esc_html_e( 'Header Images option','master-study-lite'); ?></li>
										<li><?php esc_html_e( 'Favicon, Logo, title, and tagline customization','master-study-lite'); ?></li>
										<li><?php esc_html_e( 'Advanced Color options and color pallets','master-study-lite'); ?></li>
										<li><?php esc_html_e( '100+ Font Family Options','master-study-lite'); ?></li>
										<li><?php esc_html_e( 'Pagination option','master-study-lite'); ?></li>
										<li><?php esc_html_e( 'Demo Importer','master-study-lite'); ?></li>
										<li><?php esc_html_e( 'Enable-Disable options on All sections','master-study-lite'); ?></li>
										<li><?php esc_html_e( 'Main Slider','master-study-lite'); ?></li>
										<li><?php esc_html_e( 'Woocommerce Compatible','master-study-lite'); ?></li>
										<li><?php esc_html_e( 'Unlimited Slides','master-study-lite'); ?></li>
										<li><?php esc_html_e( 'Section to show categories','master-study-lite'); ?></li>
										<li><?php esc_html_e( 'Product Listing based on category','master-study-lite'); ?></li>
										<li><?php esc_html_e( 'Top Categories Section','master-study-lite'); ?></li>
										<li><?php esc_html_e( 'Best Seller Tab','master-study-lite'); ?></li>
										<li><?php esc_html_e( 'Testimonial with custom post type','master-study-lite'); ?></li>
										<li><?php esc_html_e( 'Promotional Banners','master-study-lite'); ?></li>
										<li><?php esc_html_e( 'Partner Listing','master-study-lite'); ?></li>
										<li><?php esc_html_e( 'Shortcodes for Testimonials','master-study-lite'); ?></li>
										<li><?php esc_html_e( 'Newsletter with the help of contact form 7.','master-study-lite'); ?></li>
										<li><?php esc_html_e( 'Well-sanitized as per WordPress standards.','master-study-lite'); ?></li>
										<li><?php esc_html_e( 'Responsive layout for all devices','master-study-lite'); ?></li>
										<li><?php esc_html_e( 'Typography for the complete website','master-study-lite'); ?></li>
										<li><?php esc_html_e( 'Global Color pallete','master-study-lite'); ?></li>
										<li><?php esc_html_e( 'Section specific Color pallete','master-study-lite'); ?></li>
										<li><?php esc_html_e( 'Fully integrated with Font Awesome Icon','master-study-lite'); ?></li>
										<li><?php esc_html_e( 'Instagram Section','master-study-lite'); ?></li>
										<li><?php esc_html_e( 'Partner Listing','master-study-lite'); ?></li>
										<li><?php esc_html_e( 'Background Image Option','master-study-lite'); ?></li>
										<li><?php esc_html_e( 'Custom page templates','master-study-lite'); ?></li>
										<li><?php esc_html_e( 'Allow setting site title, tagline, logo','master-study-lite'); ?></li>
										<li><?php esc_html_e( 'Left and Right Sidebar','master-study-lite'); ?></li>
										<li><?php esc_html_e( 'Sticky post & Comment threads','master-study-lite'); ?></li>
										<li><?php esc_html_e( 'Customizable Home Page','master-study-lite'); ?></li>
										<li><?php esc_html_e( 'Multiple inner page templates','master-study-lite'); ?></li>
										<li><?php esc_html_e( 'Contact Page Template','master-study-lite'); ?></li>
										<li><?php esc_html_e( 'Blog Full width and right and left sidebar','master-study-lite'); ?></li>
										<li><?php esc_html_e( 'Recent post widget with images, Related post','master-study-lite'); ?></li>
									</ul>
								</div>
							</div>
						</div>
				</div>
			</div>
		</div>
		<div class="dashboard__blocks">
			<div class="row">
				<div class="col-md-3">
					<h3><?php esc_html_e( 'Get Support','master-study-lite'); ?></h3>
					<ol>
						<li><a target="_blank" href="<?php echo esc_url( MASTER_STUDY_LITE_FREE_SUPPORT ); ?>"><?php esc_html_e( 'Free Theme Support','master-study-lite'); ?></a></li>
						<li><a target="_blank" href="<?php echo esc_url( MASTER_STUDY_LITE_PRO_SUPPORT ); ?>"><?php esc_html_e( 'Premium Theme Support','master-study-lite'); ?></a></li>
					</ol>
				</div>

				<div class="col-md-3">
					<h3><?php esc_html_e( 'Getting Started','master-study-lite'); ?></h3>
					<ol>
						<li><?php esc_html_e( 'Start','master-study-lite'); ?> <a target="_blank" href="<?php echo esc_url( admin_url('customize.php') ); ?>"><?php esc_html_e( 'Customizing','master-study-lite'); ?></a> <?php esc_html_e( 'your website.','master-study-lite'); ?> </li>
					</ol>
				</div>
				<div class="col-md-3">
					<h3><?php esc_html_e( 'Help Docs','master-study-lite'); ?></h3>
					<ol>
						<li><a target="_blank" href="<?php echo esc_url( MASTER_STUDY_LITE_FREE_DOC ); ?>"><?php esc_html_e( 'Free Theme Documentation','master-study-lite'); ?></a></li>
						<li><a target="_blank" href="<?php echo esc_url( MASTER_STUDY_LITE_PRO_DOC ); ?>"><?php esc_html_e( 'Premium Theme Documentation','master-study-lite'); ?></a></li>
					</ol>
				</div>
				<div class="col-md-3">
					<h3><?php esc_html_e( 'Buy Premium','master-study-lite'); ?></h3>
					<ol>
						<a href="<?php echo esc_url( MASTER_STUDY_LITE_BUY_PRO ); ?>" target="_blank"><?php esc_html_e('Buy Pro', 'master-study-lite'); ?></a>
					</ol>
				</div>
			</div>
		</div>
	</div>

<?php }?>
