<?php
/**
 * Master Study Lite functions and definitions
 * @package Master Study Lite
 */
 /* Breadcrumb Begin */
 function master_study_lite_the_breadcrumb() {
 	if (!is_home()) {
 		echo '<a href="';
 			echo esc_url( home_url() );
 		echo '">';
 			bloginfo('name');
 		echo "</a> ";
 		if (is_category() || is_single()) {
 			the_category(',');
 			if (is_single()) {
 				echo "<span> ";
 					the_title();
 				echo "</span> ";
 			}
 		} elseif (is_page()) {
 			echo "<span> ";
 				the_title();
 		}
 	}
 }
/* Theme Setup */
if ( ! function_exists( 'master_study_lite_setup' ) ) :

function master_study_lite_setup() {
	
	$GLOBALS['content_width'] = apply_filters( 'master_study_lite_content_width', 640 );

	load_theme_textdomain( 'master-study-lite', get_template_directory() . '/languages' );
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'align-wide' );
	add_theme_support( 'wp-block-styles' );
	add_theme_support( 'woocommerce' );
	add_theme_support( 'wc-product-gallery-zoom' );
    add_theme_support( 'wc-product-gallery-slider' );
	add_theme_support( 'title-tag' );
	add_theme_support( 'custom-logo', array(
		'height'      => 80,
		'width'       => 80,
		'flex-height' => true,
	) );
	add_image_size('master-study-lite-homepage-thumb',240,145,true);

	register_nav_menus( array(
		'primary' => __( 'Primary Menu', 'master-study-lite' ),
	) );

	add_theme_support( 'custom-background', array(
		'default-color' => 'f1f1f1'
	) );

	add_theme_support( 'post-formats', array('image','video','gallery','audio',) );

	add_theme_support( 'html5', array(
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	add_theme_support('responsive-embeds');
	/*
	 * This theme styles the visual editor to resemble the theme style,
	 * specifically font, colors, icons, and column width.
	 */
	add_editor_style( array( 'css/editor-style.css', master_study_lite_font_url() ) );
}
endif; // master_study_lite_setup
add_action( 'after_setup_theme', 'master_study_lite_setup' );

/* Theme Widgets Setup */
function master_study_lite_widgets_init() {
	register_sidebar( array(
		'name'          => __( 'Blog Sidebar', 'master-study-lite' ),
		'description'   => __( 'Appears on posts and pages', 'master-study-lite' ),
		'id'            => 'sidebar-1',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => __( 'Posts and Pages Sidebar', 'master-study-lite' ),
		'description'   => __( 'Appears on posts and pages', 'master-study-lite' ),
		'id'            => 'sidebar-2',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => __( 'Third Column Sidebar', 'master-study-lite' ),
		'description'   => __( 'Appears on posts and pages', 'master-study-lite' ),
		'id'            => 'sidebar-3',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	//Footer widget areas
	$master_study_lite_widget_areas = get_theme_mod('master_study_lite_footer_widget_areas', '4');
	for ($master_study_lite_i=1; $master_study_lite_i <= 4; $master_study_lite_i++) {
		register_sidebar( array(
			'name'          => __( 'Footer Widget ', 'master-study-lite' ) . $master_study_lite_i,
			'id'            => 'footer-' . $master_study_lite_i,
			'description'   => '',
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		) ); 
	}

	register_sidebar( array(
		'name'          => __( 'Shop Page Sidebar', 'master-study-lite' ),
		'description'   => __( 'Appears on shop page', 'master-study-lite' ),
		'id'            => 'woocommerce_sidebar',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => __( 'Single Product Page Sidebar', 'master-study-lite' ),
		'description'   => __( 'Appears on single product page', 'master-study-lite' ),
		'id'            => 'woocommerce-single-sidebar',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
}
add_action( 'widgets_init', 'master_study_lite_widgets_init' );

/* Footer Widget */
add_theme_support( 'starter-content', array(
	'widgets' => array(
		'footer-1' => array(
			'archives',
		),
		'footer-2' => array(
			'meta',
		),
		'footer-3' => array(
			'categories',
		),
		'footer-4' => array(
			'search',
		),
	),
));

// edit

if (!function_exists('master_study_lite_edit_link')) :

    function master_study_lite_edit_link($view = 'default')
    {
    global $post;
        edit_post_link(
            sprintf(
                wp_kses(
                /* translators: %s: Name of current post. Only visible to screen readers */
                    __('Edit <span class="screen-reader-text">%s</span>', 'master-study-lite'),
                    array(
                        'span' => array(
                            'class' => array(),
                        ),
                    )
                ),
                get_the_title()
            ),
            '<span class="edit-link"><i class="fa-solid fa-pen mx-2"></i>',
            '</span>'
        );
    }
endif;

/* Theme Font URL */
function master_study_lite_font_url() {
	$font_family   = array(
		'Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900',
		'Bad Script',
		'Bebas Neue',
		'Fjalla One',
		'PT Sans:ital,wght@0,400;0,700;1,400;1,700',
		'PT Serif:ital,wght@0,400;0,700;1,400;1,700',
		'Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900',
		'Roboto Condensed:ital,wght@0,300;0,400;0,700;1,300;1,400;1,700',
		'Alex Brush',
		'Overpass:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900',
		'Montserrat:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900',
		'Playball',
		'Alegreya:ital,wght@0,400;0,500;0,600;0,700;0,800;0,900;1,400;1,500;1,600;1,700;1,800;1,900',
		'Julius Sans One',
		'Arsenal:ital,wght@0,400;0,700;1,400;1,700',
		'Slabo 13px',
		'Lato:ital,wght@0,100;0,300;0,400;0,700;0,900;1,100;1,300;1,400;1,700;1,900',
		'Overpass Mono:wght@300;400;500;600;700',
		'Source Sans Pro:ital,wght@0,200;0,300;0,400;0,600;0,700;0,900;1,200;1,300;1,400;1,600;1,700;1,900',
		'Raleway:ital,wght@0,100..900;1,100..900',
		'Merriweather:ital,wght@0,300;0,400;0,700;0,900;1,300;1,400;1,700;1,900',
		'Rubik:ital,wght@0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,300;1,400;1,500;1,600;1,700;1,800;1,900',
		'Lora:ital,wght@0,400;0,500;0,600;0,700;1,400;1,500;1,600;1,700',
		'Ubuntu:ital,wght@0,300;0,400;0,500;0,700;1,300;1,400;1,500;1,700',
		'Cabin:ital,wght@0,400;0,500;0,600;0,700;1,400;1,500;1,600;1,700',
		'Arimo:ital,wght@0,400;0,500;0,600;0,700;1,400;1,500;1,600;1,700',
		'Playfair Display:ital,wght@0,400;0,500;0,600;0,700;0,800;0,900;1,400;1,500;1,600;1,700;1,800;1,900',
		'Padauk:wght@400;700',
		'Inconsolata:wght@200;300;400;500;600;700;800;900&family=Mulish:ital,wght@0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;0,1000;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900;1,1000',
		'Bitter:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Mulish:ital,wght@0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;0,1000;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900;1,1000',
		'Pacifico',
		'Indie Flower',
		'VT323',
		'Dosis:wght@200;300;400;500;600;700;800',
		'Frank Ruhl Libre:wght@300;400;500;700;900',
		'Fjalla One',
		'Figtree:ital,wght@0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,300;1,400;1,500;1,600;1,700;1,800;1,900',
		'Oxygen:wght@300;400;700',
		'Arvo:ital,wght@0,400;0,700;1,400;1,700',
		'Noto Serif:ital,wght@0,400;0,700;1,400;1,700',
		'Lobster',
		'Crimson Text:ital,wght@0,400;0,600;0,700;1,400;1,600;1,700',
		'Yanone Kaffeesatz:wght@200;300;400;500;600;700',
		'Anton',
		'Libre Baskerville:ital,wght@0,400;0,700;1,400',
		'Bree Serif',
		'Gloria Hallelujah',
		'Abril Fatface',
		'Varela Round',
		'Vampiro One',
		'Shadows Into Light',
		'Cuprum:ital,wght@0,400;0,500;0,600;0,700;1,400;1,500;1,600;1,700',
		'Rokkitt:wght@100;200;300;400;500;600;700;800;900',
		'Vollkorn:ital,wght@0,400;0,500;0,600;0,700;0,800;0,900;1,400;1,500;1,600;1,700;1,800;1,900',
		'Francois One',
		'Orbitron:wght@400;500;600;700;800;900',
		'Patua One',
		'Acme',
		'Satisfy',
		'Josefin Slab:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;1,100;1,200;1,300;1,400;1,500;1,600;1,700',
		'Quattrocento Sans:ital,wght@0,400;0,700;1,400;1,700',
		'Architects Daughter',
		'Russo One',
		'Monda:wght@400;700',
		'Righteous',
		'Lobster Two:ital,wght@0,400;0,700;1,400;1,700',
		'Hammersmith One',
		'Courgette',
		'Permanent Marke',
		'Cherry Swash:wght@400;700',
		'Cormorant Garamond:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700',
		'Poiret One',
		'BenchNine:wght@300;400;700',
		'Economica:ital,wght@0,400;0,700;1,400;1,700',
		'Handlee',
		'Cardo:ital,wght@0,400;0,700;1,400',
		'Alfa Slab One',
		'Averia Serif Libre:ital,wght@0,300;0,400;0,700;1,300;1,400;1,700',
		'Cookie',
		'Chewy',
		'Great Vibes',
		'Coming Soon',
		'Philosopher:ital,wght@0,400;0,700;1,400;1,700',
		'Days One',
		'Kanit:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900',
		'Shrikhand',
		'Tangerine:wght@400;700',
		'IM Fell English SC',
		'Boogaloo',
		'Bangers',
		'Fredoka One',
		'Volkhov:ital,wght@0,400;0,700;1,400;1,700',
		'Shadows Into Light Two',
		'Marck Script',
		'Sacramento',
		'Unica One',
		'Dancing Script:wght@400;500;600;700',
		'Exo 2:ital,wght@0,100..900;1,100..900',
		'Archivo:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900',
		'DM Serif Display:ital@0;1',
		'Open Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;0,800;1,300;1,400;1,500;1,600;1,700;1,800',
		'Jost:ital,wght@0,100..900;1,100..900',
		'Mulish:ital,wght@0,200..1000;1,200..1000',
		'Quicksand:wght@300..700',
		'ABeeZee',
		'Sen:wght@400..800'
	);

	$query_args = array(
		'family'	=> rawurlencode(implode('|',$font_family)),
	);
	$font_url = add_query_arg($query_args,'//fonts.googleapis.com/css');
	return $font_url;
	$contents = wptt_get_webfont_url( esc_url_raw( $fonts_url ) );
}

/* Theme enqueue scripts */
function master_study_lite_scripts() {
	wp_enqueue_style( 'master-study-lite-font', master_study_lite_font_url(), array() );
	wp_enqueue_style( 'bootstrap-css', get_template_directory_uri() . '/css/bootstrap.css');
	// blocks-css
	wp_enqueue_style( 'master-study-lite-block-style', get_theme_file_uri('/css/blocks.css') );
	wp_style_add_data( 'master-study-lite-style', 'rtl', 'replace' );	
	wp_enqueue_style( 'master-study-lite-basic-style', get_stylesheet_uri() );
	wp_enqueue_style( 'font-awesome-css', get_template_directory_uri().'/css/fontawesome-all.css' );
	// body
	$master_study_lite_body_color       = get_theme_mod('master_study_lite_body_color', '');
	$master_study_lite_body_font_family = get_theme_mod('master_study_lite_body_font_family', '');
	$master_study_lite_body_font_size   = get_theme_mod('master_study_lite_body_font_size', '');
	$master_study_lite_body_font_weight   = get_theme_mod('master_study_lite_body_font_weight', '');	
			
	// Paragraph
	$master_study_lite_paragraph_color       = get_theme_mod('master_study_lite_paragraph_color', '');
	$master_study_lite_paragraph_font_family = get_theme_mod('master_study_lite_paragraph_font_family', '');
	$master_study_lite_paragraph_font_size   = get_theme_mod('master_study_lite_paragraph_font_size', '');
	$master_study_lite_paragraph_font_weight   = get_theme_mod('master_study_lite_paragraph_font_weight', '');
	// "a" tag
	$master_study_lite_atag_color       = get_theme_mod('master_study_lite_atag_color', '');
	$master_study_lite_atag_font_family = get_theme_mod('master_study_lite_atag_font_family', '');
	// "li" tag
	$master_study_lite_li_color       = get_theme_mod('master_study_lite_li_color', '');
	$master_study_lite_li_font_family = get_theme_mod('master_study_lite_li_font_family', '');
	// H1
	$master_study_lite_h1_color       = get_theme_mod('master_study_lite_h1_color', '');
	$master_study_lite_h1_font_family = get_theme_mod('master_study_lite_h1_font_family', '');
	$master_study_lite_h1_font_size   = get_theme_mod('master_study_lite_h1_font_size', '');
	$master_study_lite_h1_font_weight   = get_theme_mod('master_study_lite_h1_font_weight', '');
	// H2
	$master_study_lite_h2_color       = get_theme_mod('master_study_lite_h2_color', '');
	$master_study_lite_h2_font_family = get_theme_mod('master_study_lite_h2_font_family', '');
	$master_study_lite_h2_font_size   = get_theme_mod('master_study_lite_h2_font_size', '');
	$master_study_lite_h2_font_weight   = get_theme_mod('master_study_lite_h2_font_weight', '');
	// H3
	$master_study_lite_h3_color       = get_theme_mod('master_study_lite_h3_color', '');
	$master_study_lite_h3_font_family = get_theme_mod('master_study_lite_h3_font_family', '');
	$master_study_lite_h3_font_size   = get_theme_mod('master_study_lite_h3_font_size', '');
	$master_study_lite_h3_font_weight   = get_theme_mod('master_study_lite_h3_font_weight', '');
	// H4
	$master_study_lite_h4_color       = get_theme_mod('master_study_lite_h4_color', '');
	$master_study_lite_h4_font_family = get_theme_mod('master_study_lite_h4_font_family', '');
	$master_study_lite_h4_font_size   = get_theme_mod('master_study_lite_h4_font_size', '');
	$master_study_lite_h4_font_weight   = get_theme_mod('master_study_lite_h4_font_weight', '');
	// H5
	$master_study_lite_h5_color       = get_theme_mod('master_study_lite_h5_color', '');
	$master_study_lite_h5_font_family = get_theme_mod('master_study_lite_h5_font_family', '');
	$master_study_lite_h5_font_size   = get_theme_mod('master_study_lite_h5_font_size', '');
	$master_study_lite_h5_font_weight   = get_theme_mod('master_study_lite_h5_font_weight', '');
	// H6
	$master_study_lite_h6_color       = get_theme_mod('master_study_lite_h6_color', '');
	$master_study_lite_h6_font_family = get_theme_mod('master_study_lite_h6_font_family', '');
	$master_study_lite_h6_font_size   = get_theme_mod('master_study_lite_h6_font_size', '');
	$master_study_lite_h6_font_weight   = get_theme_mod('master_study_lite_h6_font_weight', '');

	$master_study_lite_custom_css = '
		body{
		    color:'.esc_html($master_study_lite_body_color).'!important;
		    font-family: '.esc_html($master_study_lite_body_font_family).';
		    font-size: '.esc_html($master_study_lite_body_font_size).'px;
			font-weight: '.esc_html($master_study_lite_body_font_weight).'!important;
		}
		p,span{
		    color:'.esc_html($master_study_lite_paragraph_color).'!important;
		    font-family: '.esc_html($master_study_lite_paragraph_font_family).';
		    font-size: '.esc_html($master_study_lite_paragraph_font_size).'px !important;
			font-weight: '.esc_html($master_study_lite_paragraph_font_weight).'!important;
		}
		a{
		    color:'.esc_html($master_study_lite_atag_color).'!important;
		    font-family: '.esc_html($master_study_lite_atag_font_family).';
		}
		li{
		    color:'.esc_html($master_study_lite_li_color).'!important;
		    font-family: '.esc_html($master_study_lite_li_font_family).';
		}
		h1{
		    color:'.esc_html($master_study_lite_h1_color).'!important;
		    font-family: '.esc_html($master_study_lite_h1_font_family).'!important;
		    font-size: '.esc_html($master_study_lite_h1_font_size).'px!important;
			font-weight: '.esc_html($master_study_lite_h1_font_weight).'!important;	
		}
		h2{
		    color:'.esc_html($master_study_lite_h2_color).'!important;
		    font-family: '.esc_html($master_study_lite_h2_font_family).'!important;
		    font-size: '.esc_html($master_study_lite_h2_font_size).'px!important;
			font-weight: '.esc_html($master_study_lite_h2_font_weight).'!important;
		}
		h3{
		    color:'.esc_html($master_study_lite_h3_color).'!important;
		    font-family: '.esc_html($master_study_lite_h3_font_family).'!important;
		    font-size: '.esc_html($master_study_lite_h3_font_size).'px!important;
			font-weight: '.esc_html($master_study_lite_h3_font_weight).'!important;
		}
		h4{
		    color:'.esc_html($master_study_lite_h4_color).'!important;
		    font-family: '.esc_html($master_study_lite_h4_font_family).'!important;
		    font-size: '.esc_html($master_study_lite_h4_font_size).'px!important;
			font-weight: '.esc_html($master_study_lite_h4_font_weight).'!important;
		}
		h5{
		    color:'.esc_html($master_study_lite_h5_color).'!important;
		    font-family: '.esc_html($master_study_lite_h5_font_family).'!important;
		    font-size: '.esc_html($master_study_lite_h5_font_size).'px!important;
			font-weight: '.esc_html($master_study_lite_h5_font_weight).'!important;
		}
		h6{
		    color:'.esc_html($master_study_lite_h6_color).'!important;
		    font-family: '.esc_html($master_study_lite_h6_font_family).'!important;
		    font-size: '.esc_html($master_study_lite_h6_font_size).'px!important;
			font-weight: '.esc_html($master_study_lite_h6_font_weight).'!important;
		}
	';
	wp_add_inline_style('master-study-lite-basic-style', $master_study_lite_custom_css);

	/* Theme Color sheet */
	require get_parent_theme_file_path( '/theme-color-option.php' );
	wp_add_inline_style( 'master-study-lite-basic-style',$master_study_lite_custom_css );
	wp_enqueue_script( 'tether-js', get_template_directory_uri() . '/js/tether.js', array('jquery') ,'',true);
	wp_enqueue_script( 'bootstrap-js', get_template_directory_uri() . '/js/bootstrap.js', array('jquery') ,'',true);
	wp_enqueue_script( 'master-study-lite-custom-scripts-jquery', (get_template_directory_uri()) . '/js/custom.js', array('jquery') );
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'master_study_lite_scripts' );

function master_study_lite_theme_setup() {
	define('MASTER_STUDY_LITE_LIVE_DEMO',__('https://demos.buywptemplates.com/bwt-education-theme/', 'master-study-lite'));
	define('MASTER_STUDY_LITE_BUY_PRO',__('https://www.buywptemplates.com/products/education-wordpress-theme', 'master-study-lite'));
	define('MASTER_STUDY_LITE_PRO_DOC',__('https://demos.buywptemplates.com/demo/docs/bwt-education-pro/', 'master-study-lite'));
	define('MASTER_STUDY_LITE_FREE_DOC',__('https://demos.buywptemplates.com/demo/docs/master-study/', 'master-study-lite'));
	define('MASTER_STUDY_LITE_PRO_SUPPORT',__('https://buywptemplates.com/pages/community', 'master-study-lite'));
	define('MASTER_STUDY_LITE_FREE_SUPPORT',__('https://wordpress.org/support/theme/master-study-lite/', 'master-study-lite'));
	define('MASTER_STUDY_LITE_REVIEW',__('https://wordpress.org/support/theme/master-study-lite/reviews/', 'master-study-lite'));	
	define('MASTER_STUDY_LITE_CREDIT',__('https://www.buywptemplates.com/products/free-master-study-lite-wordpress-theme', 'master-study-lite'));
}
add_action( 'after_setup_theme', 'master_study_lite_theme_setup' );

if ( ! function_exists( 'master_study_lite_credit' ) ) {
	function master_study_lite_credit(){
		echo '<a href="' . esc_url(MASTER_STUDY_LITE_CREDIT) . '" target="_blank" rel="noopener noreferrer">' . esc_html__('Master Study Lite WordPress Theme', 'master-study-lite') . '</a>';

	}
}

/* Excerpt Limit Begin */
function master_study_lite_string_limit_words($string, $word_limit) {
	$words = explode(' ', $string, ($word_limit + 1));
	if(count($words) > $word_limit)
	array_pop($words);
	return implode(' ', $words);
}

/*radio button sanitization*/
function master_study_lite_sanitize_choices( $master_study_lite_input, $setting ) {
    global $wp_customize;
    $control = $wp_customize->get_control( $setting->id );
    if ( array_key_exists( $master_study_lite_input, $control->choices ) ) {
        return $master_study_lite_input;
    } else {
        return $setting->default;
    }
}

function master_study_lite_sanitize_checkbox( $master_study_lite_input ) {
	// Boolean check
	return ( ( isset( $master_study_lite_input ) && true == $master_study_lite_input ) ? true : false );
}

function master_study_lite_sanitize_phone_number( $phone ) {
	return preg_replace( '/[^\d+]/', '', $phone );
}

/* Integer sanitization */
if ( ! function_exists( 'master_study_lite_sanitize_integer' ) ) {
	function master_study_lite_sanitize_integer( $master_study_lite_input ) {
		return (int) $master_study_lite_input;
	}
}

// Change number or products per row to 4
add_filter('loop_shop_columns', 'master_study_lite_loop_columns');
if (!function_exists('master_study_lite_loop_columns')) {
	function master_study_lite_loop_columns() {
		$master_study_lite_columns = get_theme_mod( 'master_study_lite_per_columns', 4 );
		return $master_study_lite_columns; // 4 products per row
	}
}

//Change number of products that are displayed per page (shop page)
add_filter( 'loop_shop_per_page', 'master_study_lite_shop_per_page', 20 );
function master_study_lite_shop_per_page( $master_study_lite_cols ) {
  	$cols = get_theme_mod( 'master_study_lite_product_per_page', 12 );
	return $cols;
}

//Display the related posts
if ( ! function_exists( 'master_study_lite_related_posts' ) ) {
	function master_study_lite_related_posts() {
		wp_reset_postdata();
		global $post;
		$args = array(
			'no_found_rows'          => true,
			'update_post_meta_cache' => false,
			'update_post_term_cache' => false,
			'ignore_sticky_posts'    => 1,
			'orderby'                => 'rand',
			'post__not_in'           => array( $post->ID ),
			'posts_per_page'         => absint( get_theme_mod( 'master_study_lite_related_posts_count_number', '3' ) ),
		);
		// Categories
		if ( get_theme_mod( 'master_study_lite_related_posts_taxanomies', 'categories' ) == 'categories' ) {

			$cats = get_post_meta( $post->ID, 'related-posts', true );

			if ( ! $cats ) {
				$cats                 = wp_get_post_categories( $post->ID, array( 'fields' => 'ids' ) );
				$args['category__in'] = $cats;
			} else {
				$args['cat'] = $cats;
			}
		}
		// Tags
		if ( get_theme_mod( 'master_study_lite_related_posts_taxanomies', 'categories' ) == 'tags' ) {

			$tags = get_post_meta( $post->ID, 'related-posts', true );

			if ( ! $tags ) {
				$tags            = wp_get_post_tags( $post->ID, array( 'fields' => 'ids' ) );
				$args['tag__in'] = $tags;
			} else {
				$args['tag_slug__in'] = explode( ',', $tags );
			}
			if ( ! $tags ) {
				$break = true;
			}
		}
		$query = ! isset( $break ) ? new WP_Query( $args ) : new WP_Query();
		return $query;
	}
}

function master_study_lite_enable_post_featured_image(){
	if(get_theme_mod('master_study_lite_post_featured_image') == 'Image' ) {
		return true;
	}
	return false;
}

function master_study_lite_post_color_enabled(){
	if(get_theme_mod('master_study_lite_post_featured_image') == 'Color' ) {
		return true;
	}
	return false;
}

function master_study_lite_enable_post_image_custom_dimention(){
	if(get_theme_mod('master_study_lite_post_featured_image_dimention') == 'Custom' ) {
		return true;
	}
	return false;
}

function master_study_lite_show_post_color(){
	if(get_theme_mod('master_study_lite_post_featured_image') == 'Color' ) {
		return true;
	}
	return false;
}

// Reset all theme settings
function master_study_lite_reset_demo_import_settings() {
    if (current_user_can('manage_options')) {
        // List only demo import-related settings to reset
		remove_theme_mod('master_study_lite_topbar_hide');
		remove_theme_mod('master_study_lite_top_sidebar_phone_number');
		remove_theme_mod('master_study_lite_top_sidebar_email_address');
		remove_theme_mod('master_study_lite_facebook_url');
		remove_theme_mod('master_study_lite_twitter_url');
		remove_theme_mod('master_study_lite_instagram_url');
		remove_theme_mod('master_study_lite_slider_hide');
		remove_theme_mod('master_study_lite_slide_number');
		remove_theme_mod('master_study_lite_slider_bg_image');
		remove_theme_mod('master_study_lite_slider_small_title');
		remove_theme_mod('master_study_lite_slider_title');
		remove_theme_mod('master_study_lite_slider_desc_text');
		remove_theme_mod('master_study_lite_slider_btn_text');
		remove_theme_mod('master_study_lite_section_title');
		remove_theme_mod('master_study_lite_faculties_image');
		remove_theme_mod('master_study_lite_member_name');
		remove_theme_mod('master_study_lite_add_designation');
		remove_theme_mod('master_study_lite_add_description');
		remove_theme_mod('master_study_lite_footer_text');

        wp_send_json_success(array('message' => __('Demo import settings have been reset.', 'master-study-lite')));
    } else {
        wp_send_json_error(array('message' => __('Permission denied.', 'master-study-lite')));
    }
}
add_action('wp_ajax_master_study_lite_reset_demo_import_settings', 'master_study_lite_reset_demo_import_settings'); 

/* Implement the Custom Header feature. */
require get_template_directory() . '/inc/custom-header.php';

/* Custom template tags for this theme. */
require get_template_directory() . '/inc/template-tags.php';

/* Load Customizer file. */
require get_template_directory() . '/inc/customizer.php';

/* Load Customizer file. */
require get_template_directory() . '/wptt-webfont-loader.php';

/* Load welcome message.*/
require get_template_directory() . '/inc/dashboard/get_started_info.php';

/* TGM */
require get_template_directory() . '/inc/tgm/tgm.php';
