<?php
/**
 * The template for displaying the footer.
 * @package Master Study Lite
 */
?>
<?php if( get_theme_mod( 'master_study_lite_hide_show_scroll',true) != '' || get_theme_mod( 'master_study_lite_display_scroll',true) != ''){ ?>
    <?php $master_study_lite_theme_lay = get_theme_mod( 'master_study_lite_footer_options','Right');
    if($master_study_lite_theme_lay == 'Left align'){ ?>
        <a href="#" id="scrollbutton" class="left"><i class="<?php echo esc_attr(get_theme_mod('master_study_lite_back_to_top_icon','fas fa-long-arrow-alt-up')); ?>"></i><span class="screen-reader-text"><?php esc_html_e( 'Back to Top', 'master-study-lite' ); ?></span></a>
    <?php }else if($master_study_lite_theme_lay == 'Center align'){ ?>
        <a href="#" id="scrollbutton" class="center"><i class="<?php echo esc_attr(get_theme_mod('master_study_lite_back_to_top_icon','fas fa-long-arrow-alt-up')); ?>"></i><span class="screen-reader-text"><?php esc_html_e( 'Back to Top', 'master-study-lite' ); ?></span></a>
    <?php }else{ ?>
        <a href="#" id="scrollbutton"><i class="<?php echo esc_attr(get_theme_mod('master_study_lite_back_to_top_icon','fas fa-long-arrow-alt-up')); ?>"></i><span class="screen-reader-text"><?php esc_html_e( 'Back to Top', 'master-study-lite' ); ?></span></a>
    <?php }?>
<?php }?>
<footer role="contentinfo">
    <?php if( get_theme_mod( 'master_study_lite_footer_hide',true) != '') { ?>
    <?php //Set widget areas classes based on user choice
        $master_study_lite_widget_areas = get_theme_mod('master_study_lite_footer_widget_areas', '4');
        if ($master_study_lite_widget_areas == '3') {
            $master_study_lite_cols = 'col-lg-4 col-md-6 col-sm-12';
        } elseif ($master_study_lite_widget_areas == '4') {
            $master_study_lite_cols = 'col-lg-3 col-md-6 col-sm-12';
        } elseif ($master_study_lite_widget_areas == '2') {
            $master_study_lite_cols = 'col-md-6 col-sm-12';
        } else {
            $master_study_lite_cols = 'col-md-12 col-sm-12';
        }
    ?>
    <aside id="sidebar-footer" class="footer-wp" role="complementary">
        <div class="container">
            <div class="row">
                <div class="<?php echo esc_attr($master_study_lite_cols); ?> footer-block">
                    <?php if (is_active_sidebar('footer-1')) : ?>
                        <?php dynamic_sidebar('footer-1'); ?>
                    <?php else : ?>
                        <aside id="search" class="widget pb-3" role="complementary" aria-label="<?php esc_attr_e('footer1', 'master-study-lite'); ?>">
                            <h3 class="widget-title"><?php esc_html_e( 'Search', 'master-study-lite' ); ?></h3>
                            <?php get_search_form(); ?>
                        </aside>
                    <?php endif; ?>
                </div>

                <div class="<?php echo esc_attr($master_study_lite_cols); ?> footer-block">
                    <?php if (is_active_sidebar('footer-2')) : ?>
                        <?php dynamic_sidebar('footer-2'); ?>
                    <?php else : ?>
                        <aside id="archives" class="widget pb-3" role="complementary" aria-label="<?php esc_attr_e('footer2', 'master-study-lite'); ?>">
                            <h3 class="widget-title"><?php esc_html_e( 'Archives', 'master-study-lite' ); ?></h3>
                            <ul>
                                <?php wp_get_archives( array( 'type' => 'monthly' ) ); ?>
                            </ul>
                        </aside>
                    <?php endif; ?>
                </div>

                <div class="<?php echo esc_attr($master_study_lite_cols); ?> footer-block">
                    <?php if (is_active_sidebar('footer-3')) : ?>
                        <?php dynamic_sidebar('footer-3'); ?>
                    <?php else : ?>
                        <aside id="meta" class="widget pb-3" role="complementary" aria-label="<?php esc_attr_e('footer3', 'master-study-lite'); ?>">
                            <h3 class="widget-title"><?php esc_html_e( 'Meta', 'master-study-lite' ); ?></h3>
                            <ul>
                                <?php wp_register(); ?>
                                <li><?php wp_loginout(); ?></li>
                                <?php wp_meta(); ?>
                            </ul>
                        </aside>
                    <?php endif; ?>
                </div>

                <div class="<?php echo esc_attr($master_study_lite_cols); ?> footer-block">
                    <?php if (is_active_sidebar('footer-4')) : ?>
                        <?php dynamic_sidebar('footer-4'); ?>
                    <?php else : ?>
                        <aside id="categories" class="widget pb-3" role="complementary" aria-label="<?php esc_attr_e('footer4', 'master-study-lite'); ?>">
                            <h3 class="widget-title"><?php esc_html_e( 'Categories', 'master-study-lite' ); ?></h3>
                            <ul>
                                <?php wp_list_categories('title_li=');  ?>
                            </ul>
                        </aside>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </aside>
    <?php }?>
    <?php if( get_theme_mod( 'master_study_lite_copyright_hide',true) != '') { ?>
        <div class="copyright-wrapper py-3 px-0">
            <div class="container">
                <p><?php master_study_lite_credit(); ?> <?php echo esc_html__(get_theme_mod('master_study_lite_footer_copy',__('By Buywptemplate','master-study-lite'))); ?></p>
                <?php if( get_theme_mod( 'master_study_lite_footer_social_hide', false) != '') { ?>
                    <?php if(get_theme_mod('master_study_lite_footer_facebook_url') != '' || get_theme_mod('master_study_lite_footer_instagram_url') != '' || get_theme_mod('master_study_lite_footer_twitter_url') != '' || get_theme_mod('master_study_lite_footer_linkedin_url') != ''){ ?>
                        <div class="socialicons mt-2">
                            <?php if(get_theme_mod('master_study_lite_footer_facebook_url') != ''){ ?>
                                <a target="_blank" href="<?php echo esc_url(get_theme_mod('master_study_lite_footer_facebook_url')); ?>"><i class="<?php echo esc_attr(get_theme_mod('master_study_lite_footer_facebook_icon','fab fa-facebook-f')); ?>"></i><span class="screen-reader-text"><?php echo esc_html('Facebook', 'master-study-lite'); ?></span></a>
                            <?php }?>
                            <?php if(get_theme_mod('master_study_lite_footer_instagram_url') != ''){ ?>
                                <a target="_blank" href="<?php echo esc_url(get_theme_mod('master_study_lite_footer_instagram_url')); ?>"><i class="<?php echo esc_attr(get_theme_mod('master_study_lite_footer_instagram_icon','fab fa-instagram')); ?>"></i><span class="screen-reader-text"><?php echo esc_html('Instagram', 'master-study-lite'); ?></span></a>
                            <?php }?>
                            <?php if(get_theme_mod('master_study_lite_footer_twitter_url') != ''){ ?>
                                <a target="_blank" href="<?php echo esc_url(get_theme_mod('master_study_lite_footer_twitter_url')); ?>"><i class="<?php echo esc_attr(get_theme_mod('master_study_lite_footer_twitter_icon','fab fa-twitter')); ?>"></i><span class="screen-reader-text"><?php echo esc_html('Twitter', 'master-study-lite'); ?></span></a>
                            <?php }?>
                            <?php if(get_theme_mod('master_study_lite_footer_linkedin_url') != ''){ ?>
                                <a target="_blank" href="<?php echo esc_url(get_theme_mod('master_study_lite_footer_linkedin_url')); ?>"><i class="<?php echo esc_attr(get_theme_mod('master_study_lite_footer_linkedin_icon','fa-brands fa-linkedin-in')); ?>"></i><span class="screen-reader-text"><?php echo esc_html('Youtube', 'master-study-lite'); ?></span></a>
                            <?php }?>
                        </div>
                    <?php }?>
                <?php }?>
            </div>
            </div>
            <div class="clear"></div>
        </div>
    <?php }?>
</footer>

<?php wp_footer(); ?>

</body>
</html>
